% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcNormLoadings}
\alias{calcNormLoadings}
\title{Calculate loadings for each factor}
\usage{
calcNormLoadings(object)
}
\arguments{
\item{object}{\code{liger} object. Should call quantileNorm before calling.}
}
\value{
A dataframe, such that each column represents the contribution of a specific matrix (W, V_1, V_2, etc. )
}
\description{
Calculates the contribution of each factor of W,V, and U to the reconstruction.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
# Minimum specification for fast example pass
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
calcNormLoadings(ligerex)
}
