% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcPurity}
\alias{calcPurity}
\title{Calculate purity}
\usage{
calcPurity(object, classes.compare, verbose = TRUE)
}
\arguments{
\item{object}{\code{liger} object. Should run quantileAlignSNF before calling.}

\item{classes.compare}{Clustering with which to compare (named vector).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
Purity value.
}
\description{
Calculates purity for \code{liger} clustering and external clustering (true clusters/classes).
Purity can sometimes be a more useful metric when the clustering to be tested contains more
subgroups or clusters than the true clusters (or classes). Purity also ranges from 0 to 1,
with a score of 1 representing a pure, or accurate, clustering.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
# Specification for minimal example run time, not converging
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
agreement <- calcARI(ligerex, ligerex@clusters)
}
