% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{deg.pw}
\alias{deg.pw}
\title{Data frame for example pairwise DEG test result}
\format{
data.frame object of 1743 rows with columns:
\itemize{
\item feature: gene names, 249 unique genes repeated 7 times for the tests
done for 7 clusters. (1 less cluster than in \code{\link{deg.marker}} due to
too tiny sample size in the smallest cluster)
\item group: cluster names, 7 unique cluster names, dividing the tests.
\item logFC: log fold change of the gene expression between the condition of
interest against the control condition.
\item pval: p-value of the DEG test.
\item padj: adjusted p-value of the DEG test.
\item pct_in: percentage of cells in the condition of interest expressing the
gene.
\item pct_out: percentage of cells in the control condition expressing the
gene.
}
}
\usage{
deg.pw
}
\description{
The data frame is the direct output of pairwise DEG test applied on example
dataset which can be loaded with \code{data("pbmc")}. The DEG test was done
with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{defaultCluster(pbmc) <- pbmcPlot$leiden_cluster
degTest <- runPairwiseDEG(
    pbmc,
    groupTest = "stim",
    groupCtrl = "ctrl",
    variable1 = "dataset",
    splitBy = "defaultCluster"
)`
}\if{html}{\out{</div>}}

The result is for the DEG test split for each cluster in the dataset, and
within each cluster, compare the cells from "stim" against the cells from
"ctrl".
}
\seealso{
\code{\link[=runPairwiseDEG]{runPairwiseDEG()}}
}
\keyword{datasets}
