% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotDensityDimRed}
\alias{plotDensityDimRed}
\title{Create density plot basing on specified coordinates}
\usage{
plotDensityDimRed(
  object,
  useDimRed = NULL,
  splitBy = NULL,
  combinePlot = TRUE,
  minDensity = 8,
  contour = TRUE,
  contourLineWidth = 0.3,
  contourBins = 5,
  dot = TRUE,
  dotColor = "grey",
  dotSize = 0.6,
  dotAlpha = 0.3,
  dotRaster = NULL,
  title = NULL,
  legendFillTitle = "Density",
  colorPalette = "magma",
  colorDirection = -1,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in the \code{cellMeta} slot. Default uses default dimension reduction.}

\item{splitBy}{Character vector of categorical variable names in
\code{cellMeta} slot. Split all cells by groupings on this/these variable(s)
to produce a density plot containing only the cells in each group. Default
\code{NULL}.}

\item{combinePlot}{Logical, whether to utilize
\code{\link[cowplot]{plot_grid}} to combine multiple plots into one. Default
\code{TRUE} returns combined ggplot. \code{FALSE} returns a list of ggplot
or a single ggplot when only one plot is requested.}

\item{minDensity}{A positive number to filter out low density region colored
on plot. Default \code{8}. Setting zero will show density on the whole panel.}

\item{contour}{Logical, whether to draw the contour line. Default
\code{TRUE}.}

\item{contourLineWidth}{Numeric, the width of the contour line. Default
\code{0.3}.}

\item{contourBins}{Number of contour bins. Higher value generates more
contour lines. Default \code{5}.}

\item{dot}{Logical, whether to add scatter plot of all cells, even when
density plot is splitted with \code{splitBy}. Default \code{TRUE}.}

\item{dotColor, dotSize, dotAlpha}{Numeric, controls the appearance of all
dots. Default \code{"grey"}, \code{0.6} and \code{0.3}, respectively.}

\item{dotRaster}{Logical, whether to rasterize the scatter plot. Default
\code{NULL} automatically rasterizes the dots when number of total cells to
be plotted exceeds 100,000.}

\item{title}{Text of main title of the plots. Default \code{NULL}. Length
of character vector input should match with number of plots generated.}

\item{legendFillTitle}{Text of legend title. Default \code{"Density"}.}

\item{colorPalette}{Name of the option for
\code{\link[ggplot2]{scale_fill_viridis_c}}. Default \code{"magma"}.}

\item{colorDirection}{Color gradient direction for
\code{\link[ggplot2]{scale_fill_viridis_c}}. Default \code{-1}.}

\item{...}{
  Arguments passed on to \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{title,subtitle,xlab,ylab}}{Main title, subtitle or X/Y axis title text.
By default, no main title or subtitle will be set, and X/Y axis title will be
the names of variables used for plotting. Use \code{NULL} to hide elements.
\code{TRUE} for \code{xlab} or \code{ylab} shows default values.}
    \item{\code{showLegend}}{Whether to show the legend. Default \code{TRUE}.}
    \item{\code{legendPosition}}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"right"}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{titleSize,xTitleSize,yTitleSize,legendTitleSize}}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}
    \item{\code{subtitleSize,xTextSize,yTextSize,legendTextSize}}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
A ggplot object when only one plot is generated, A ggplot object
combined with \code{\link[cowplot]{plot_grid}} when multiple plots and
\code{combinePlot = TRUE}. A list of ggplot when multiple plots and
\code{combinePlot = FALSE}.
}
\description{
This function shows the cell density presented in a 2D
dimensionality reduction coordinates. Density is shown with coloring and
contour lines. A scatter plot of the dimensionality reduction is added as
well. The density plot can be splitted by categorical variables (e.g.
\code{"dataset"}), while the scatter plot will always be shown for all cells
in subplots as a reference of the global structure.
}
\examples{
# Example dataset has small number of cells, thus cutoff adjusted.
plotDensityDimRed(pbmcPlot, minDensity = 1)
}
