% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{plotVarFeatures}
\alias{plotVarFeatures}
\title{Plot the variance vs mean of feature expression}
\usage{
plotVarFeatures(object, combinePlot = TRUE, dotSize = 1, ...)
}
\arguments{
\item{object}{\linkS4class{liger} object. \code{\link{selectGenes}} needs to
be run in advance.}

\item{combinePlot}{Logical. If \code{TRUE}, sub-figures for all datasets will
be combined into one plot. if \code{FALSE}, a list of plots will be returned.
Default \code{TRUE}.}

\item{dotSize}{Controls the size of dots in the main plot. Default
\code{0.8}.}

\item{...}{More theme setting parameters passed to
\code{\link{.ggplotLigerTheme}}.}
}
\value{
\code{ggplot} object when \code{combinePlot = TRUE}, a list of
\code{ggplot} objects when \code{combinePlot = FALSE}
}
\description{
For each dataset where the feature variablitity is calculated,
a plot of log10 feature expression variance and log10 mean will be produced.
Features that are considered as variable would be highlighted in red.
}
\examples{
pbmc <- normalize(pbmc)
pbmc <- selectGenes(pbmc)
plotVarFeatures(pbmc)
}
