% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedding.R
\name{runUMAP}
\alias{runUMAP}
\title{Perform UMAP Dimensionality Reduction}
\usage{
runUMAP(
  object,
  useRaw = NULL,
  useDims = NULL,
  nDims = 2,
  distance = c("cosine", "euclidean", "manhattan", "hamming"),
  nNeighbors = 20,
  minDist = 0.1,
  dimredName = "UMAP",
  asDefault = NULL,
  seed = 42,
  verbose = getOption("ligerVerbose", TRUE),
  k = nDims,
  use.raw = useRaw,
  dims.use = useDims,
  n_neighbors = nNeighbors,
  min_dist = minDist,
  rand.seed = seed,
  ...
)
}
\arguments{
\item{object}{\linkS4class{liger} object with factorization results.}

\item{useRaw}{Whether to use un-aligned cell factor loadings (\eqn{H}
matrices). Default \code{NULL} search for aligned factor loadings first
and un-aligned loadings then.}

\item{useDims}{Index of factors to use for computing the embedding. Default
\code{NULL} uses all factors.}

\item{nDims}{Number of dimensions to reduce to. Default \code{2}.}

\item{distance}{Character. Metric used to measure distance in the input
space. Default \code{"cosine"}, alternative options include:
\code{"euclidean"}, \code{"manhattan"} and \code{"hamming"}.}

\item{nNeighbors}{Number of neighboring points used in local approximations
of manifold structure. Default \code{20}.}

\item{minDist}{Numeric. Controls how tightly the embedding is allowed
compress points together. Default \code{0.1}.}

\item{dimredName}{Name of the variable in \code{cellMeta} slot to store the
result matrix. Default \code{"UMAP"}.}

\item{asDefault}{Logical, whether to set the resulting dimRed as default for
visualization. Default \code{NULL} will set it when no default is set.}

\item{seed}{Random seed for reproducibility. Default \code{42}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{k, use.raw, dims.use, n_neighbors, min_dist, rand.seed}{\bold{Deprecated}.
See Usage section for replacement.}

\item{...}{Additional argument passed to \code{uwot::umap()}.}
}
\value{
The \code{object} where a \code{"UMAP"} variable is updated in the
\code{cellMeta} slot with the whole 2D embedding matrix.
}
\description{
Run UMAP on the aligned cell factors (result from
\code{\link{alignFactors}}), or unaligned cell factors (raw result from
\code{\link{runIntegration}})) to generate a 2D embedding for visualization
(or general dimensionality reduction). Has option to run on subset of
factors. It is generally recommended to use this method for dimensionality
reduction with extremely large datasets. The underlying UMAP calculation
imports uwot \code{\link[uwot]{umap}}.
}
\details{
For \code{nNeighbors}, larger values will result in more global
structure being preserved at the loss of detailed local structure. In general
this parameter should often be in the range 5 to 50, with a choice of 10 to
15 being a sensible default.

For \code{minDist}, larger values ensure embedded points are more evenly
distributed, while smaller values allow the algorithm to optimize more
accurately with regard to local structure. Sensible values are in the range
0.001 to 0.5, with 0.1 being a reasonable default.
}
\examples{
pbmc <- runUMAP(pbmcPlot)
}
\seealso{
\code{\link{runTSNE}}
}
