% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/list.group.R
\name{list.class}
\alias{list.class}
\title{Classify list elments into unique but non-exclusive cases}
\usage{
list.class(.data, ..., sorted = TRUE)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{...}{keys}

\item{sorted}{\code{TRUE} to sort the group keys. Ignored when the key has
multiple entries.}
}
\value{
a list of possible cases each of which contains elements belonging to
the case non-exclusively.
}
\description{
In non-tabular data, a certain field may take multiple values in a
collection non-exclusively. To classify these elements into different
cases, this function detects all possible cases and for each case all
elements are examined whether to belong to that case.
}
\examples{
x <-
  list(
    p1=list(name='Ken',age=24,
      interest=c('reading','music','movies'),
      lang=list(r=2,csharp=4,python=3)),
    p2=list(name='James',age=25,
      interest=c('sports','music'),
      lang=list(r=3,java=2,cpp=5)),
    p3=list(name='Penny',age=24,
      interest=c('movies','reading'),
      lang=list(r=1,cpp=4,python=2)))
list.class(x,interest)
list.class(x,names(lang))
}

