% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/list.stack.R
\name{list.stack}
\alias{list.stack}
\title{Stack all list elements to tabular data}
\usage{
list.stack(.data, ..., data.table = FALSE)
}
\arguments{
\item{.data}{\code{list} of \code{vector}s, \code{list}s,
\code{data.frame}s or \code{data.table}s.}

\item{...}{additional parameters passed to \code{data.table::rbindlist}.}

\item{data.table}{\code{TRUE} to keep the result as \code{data.table}}
}
\description{
Stack all list elements to tabular data
}
\examples{
\dontrun{
x <- lapply(1:3, function(i) { list(a=i,b=i^2) })
list.stack(x)

x <- lapply(1:3, function(i) { list(a=i,b=i^2,c=letters[i])})
list.stack(x)

x <- lapply(1:3, function(i) { data.frame(a=i,b=i^2,c=letters[i]) })
list.stack(x)

x <- lapply(1:3, function(i) { data.frame(a=c(i,i+1), b=c(i^2,i^2+1))})
list.stack(x)
}
}

