% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utils.R
\name{tryGet}
\alias{tryGet}
\title{Try to get the value of a symbol if exists or return a default value}
\usage{
tryGet(symbol, def = NULL, ..., envir = parent.frame())
}
\arguments{
\item{symbol}{the symbol to examine}

\item{def}{the default value if the symbol does not exist}

\item{...}{additional parameters passed to \code{exists} and \code{get}}

\item{envir}{the environment to examine whether the symbol exists
and get the symbol}
}
\description{
Try to get the value of a symbol if exists or return a default value
}
\details{
By default, the symbol is examined in \code{envir} without inheritance,
that is, if the symbol does not exist in \code{envir} the default value
\code{def} will be returned.
}
\examples{
x <- list(a=c(x=1,y=2),b=c(x=2,p=3))
list.map(x, tryGet(y,0))
}

