% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmargint-fn.R
\name{plot.margint}
\alias{plot.margint}
\title{Diagnostic plots for objects of class \code{margint}}
\usage{
\method{plot}{margint}(x, derivative = FALSE, which = 1:np,
  ask = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{margint}, a result of a call to \code{\link{margint.cl}} or \code{\link{margint.rob}}.}

\item{derivative}{if TRUE, it plots the q-th derivatives. Defaults to FALSE.}

\item{which}{vector of indices of explanatory variables for which partial residuals plots will be generated. Defaults to all available explanatory variables.}

\item{ask}{logical value. If \code{TRUE}, the graphical device will prompt before going to the next page/screen of output.}

\item{...}{additional other arguments.}
}
\description{
Plot method for class \code{margint}.
}
\examples{
function.g1 <- function(x1) 24*(x1-1/2)^2-2
function.g2 <- function(x2) 2*pi*sin(pi*x2)-4
set.seed(140)
n <- 150
x1 <- runif(n)
x2 <- runif(n)
X <- cbind(x1, x2)
eps <- rnorm(n,0,sd=0.15)
regresion <- function.g1(x1) + function.g2(x2)
y <- regresion + eps
bandw <- matrix(0.25,2,2)
set.seed(8090)
nQ <- 80 
Qmeasure <- matrix(runif(nQ*2), nQ, 2)
fit.rob <- margint.rob(Xp=X, yp=y, windows=bandw, type='alpha', degree=1, Qmeasure=Qmeasure)
plot(fit.rob, which=1)

}
\author{
Alejandra Mercedes Martinez \email{ale_m_martinez@hotmail.com}
}
