/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import cern.jet.stat.Probability;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.MCFSFinalCV;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.mcfsEngine.framework.MCFSClassic;
import dmLab.mcfs.mcfsEngine.framework.MCFSFramework;
import dmLab.mcfs.mcfsEngine.framework.MCFSPermutation;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public final class MCFSExperiment
implements Runnable {
    private MCFSFramework mcfs;
    public MCFSParams mcfsParams;
    private Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSExperiment(long seed) {
        void var1_1;
        this.random = new Random((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        if (!this.mcfsParams.check(null)) {
            return;
        }
        DataFrame permutationRIValues = null;
        ArrayList<Float> maxPermutationRI = new ArrayList<Float>();
        ArrayList<Float> maxPermutationID = new ArrayList<Float>();
        ArrayList<String> permPrefix = new ArrayList<String>();
        int i = 0;
        while (i < this.mcfsParams.cutoffPermutations) {
            System.out.println("*** MCFS-ID Cutoff Permutation Experiment #" + (i + 1) + " ***");
            this.mcfs = new MCFSPermutation(this.random);
            ((MCFSPermutation)this.mcfs).permPrefix = String.valueOf(((MCFSPermutation)this.mcfs).permPrefix) + (i + 1) + "_";
            permPrefix.add(((MCFSPermutation)this.mcfs).permPrefix);
            if (!this.mcfs.run(this.mcfsParams)) {
                return;
            }
            AttributesRI imp = this.mcfs.globalStats.getAttrImportances()[0];
            if (permutationRIValues == null) {
                permutationRIValues = MCFSExperiment.createPermutationResult(this.mcfs.mcfsArrays.sourceArray, this.mcfsParams);
            }
            permutationRIValues.setColumn(i + 1, imp.getImportanceValues(imp.mainMeasureIdx));
            float[] minMax = imp.getMinMaxImportances(imp.mainMeasureIdx);
            maxPermutationRI.add(Float.valueOf(minMax[1]));
            if (this.mcfs.globalStats.getAttrConnections() != null) {
                maxPermutationID.add(Float.valueOf(this.mcfs.globalStats.getAttrConnections().getMaxID()));
            }
            ++i;
        }
        String experimentName = this.mcfsParams.getExperimentName();
        this.mcfs = new MCFSClassic(this.random);
        if (!this.mcfs.run(this.mcfsParams)) {
            return;
        }
        AttributesRI importancesClassic = this.mcfs.globalStats.getAttrImportances()[0];
        if (permutationRIValues != null) {
            void var3_4;
            void var2_3;
            int mainMeasureIndex = importancesClassic.mainMeasureIdx;
            DataFrame p_values = MCFSExperiment.calc_pValues$662b6a5a(permutationRIValues, importancesClassic.getImportanceValues(mainMeasureIndex));
            permutationRIValues.cbind(p_values);
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_PERMUTATIONS, permutationRIValues.toString());
            System.out.println("");
            System.out.println("*** Calculation of Minimal Important RI ***");
            float[] minMaxRI = importancesClassic.getMinMaxImportances(mainMeasureIndex);
            System.out.println("Max obtained RI = " + minMaxRI[1]);
            System.out.println("Max Permutation RI = " + Arrays.toString(maxPermutationRI.toArray()));
            double cutoffRI = MCFSExperiment.getCutoff(this.mcfs.mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationRI.toArray()));
            Ranking topRanking = importancesClassic.getTopRanking(mainMeasureIndex, (float)cutoffRI);
            int topRankingSize = 0;
            if (topRanking != null) {
                topRankingSize = topRanking.size();
            }
            System.out.println("Minimal important (based on permutation) RI = " + DiscFunctions.format(cutoffRI, 7));
            System.out.println("Top important (based on permutation) attributes number = " + topRankingSize);
            double cutoffID = Double.NaN;
            if (this.mcfsParams.buildID) {
                System.out.println("");
                System.out.println("*** Calculation of Minimal Important ID ***");
                cutoffID = MCFSExperiment.getCutoff(this.mcfs.mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationID.toArray()));
                System.out.println("Minimal important (based on permutation) ID = " + DiscFunctions.format(cutoffID, 7));
            }
            Object cutoff = this.mcfs.globalStats.getCutoff().getCutoffTable();
            cutoff = ((DataFrame)cutoff).excludeRows(new int[]{((DataFrame)cutoff).rows() - 1});
            DataFrame cutoffRow = new DataFrame(1, (DataFrame)cutoff);
            int lastRowIdx = cutoffRow.rows() - 1;
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("method"), "permutations");
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minRI"), cutoffRI);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("size"), topRankingSize);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minID"), cutoffID);
            ((DataFrame)cutoff).rbind(cutoffRow);
            this.mcfs.globalStats.getCutoff().setCutoffTable((DataFrame)cutoff);
            this.mcfs.globalStats.getCutoff().addMeanValue(importancesClassic);
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, this.mcfs.globalStats.getCutoff().toString());
            this.removePermResultTempFiles(permPrefix);
            String topRankingMethod = this.mcfs.globalStats.getCutoff().getMethod(this.mcfs.mcfsParams.cutoffMethod);
            topRankingSize = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(topRankingMethod);
            cutoff = importancesClassic.getTopRankingSize(mainMeasureIndex, (int)var2_3);
            System.out.println("");
            System.out.println("*** Final top important (based on " + (String)var3_4 + ") attributes = " + ((Ranking)cutoff).size());
            DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, ((Ranking)cutoff).toString());
        }
        if (this.mcfsParams.finalCV) {
            int topRankingSize = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(this.mcfs.mcfsParams.cutoffMethod);
            if (topRankingSize == 0) {
                topRankingSize = 8;
            }
            MCFSFinalCV simpleCV = new MCFSFinalCV(new int[]{Classifier.J48, Classifier.NB, Classifier.SVM, Classifier.KNN, Classifier.LOGISTIC, Classifier.RIPPER}, this.random);
            int[] cutoffValues = MCFSExperiment.getCutoffValues(new int[]{topRankingSize});
            System.out.println("");
            System.out.println("*** Running Cross Validation experiment on top " + Arrays.toString(cutoffValues) + " attributes ***");
            DataFrame res = simpleCV.run(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], cutoffValues, this.mcfsParams.foldsCV, this.mcfsParams.finalCVSetSize, this.mcfsParams.finalCVRepetitions);
            if (this.mcfs.saveResutFiles) {
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_CV_RESULT, res.toString());
            }
        }
        if (this.mcfsParams.finalRuleset) {
            void var1_1;
            int topRankingSize = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(this.mcfs.mcfsParams.cutoffMethod);
            if (topRankingSize == 0) {
                topRankingSize = 2;
            }
            System.out.println("");
            System.out.println("*** Building RIPPER ruleset on top " + topRankingSize + " attributes ***");
            FArray topRankingArray = (FArray)DiscFunctions.selectColumns(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], topRankingSize);
            ClassificationBody classification = new ClassificationBody(this.random);
            classification.setParameters(new ClassificationParams());
            classification.classParams.debug = false;
            classification.classParams.verbose = false;
            classification.classParams.saveClassifier = false;
            classification.classParams.savePredictionResult = false;
            classification.classParams.classifierCfgPATH = "";
            classification.classParams.classifier = Classifier.RIPPER;
            classification.createClassifier();
            classification.singleTrainTest(topRankingArray, topRankingArray);
            String ripperResult = String.valueOf(classification.classifier.toString(false)) + "\n\n";
            classification.createClassifier();
            classification.cleanStats();
            classification.classParams.folds = this.mcfsParams.foldsCV;
            classification.classParams.repetitions = this.mcfsParams.finalCVRepetitions;
            classification.multipleCV(topRankingArray);
            ripperResult = String.valueOf(ripperResult) + "##### Cross Validation Result (10 folds repeated " + this.mcfsParams.finalCVRepetitions + " times) #####\n" + var1_1.toStringCMatrix();
            System.out.println(ripperResult);
            if (this.mcfs.saveResutFiles) {
                DiscFunctions.saveString(String.valueOf(this.mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_RULESET, ripperResult);
            }
        }
    }

    private int removePermResultTempFiles(ArrayList<String> permPrefix) {
        String experimentName = this.mcfsParams.getExperimentName();
        int i = 0;
        while (i < permPrefix.size()) {
            String fileName = String.valueOf(this.mcfsParams.resFilesPATH) + permPrefix.get(i) + experimentName + "__" + MCFSParams.FILESUFIX_IMPORTANCES;
            File f = new File(fileName);
            if (f.exists()) {
                f.delete();
            }
            ++i;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame createPermutationResult(FArray inputArrray, MCFSParams mcfsParams) {
        void var3_4;
        FArray fArray;
        void var2_2;
        void var1_1;
        String[] colNames = new String[mcfsParams.cutoffPermutations + 1];
        short[] colTypes = new short[colNames.length];
        colNames[0] = "attribute";
        colTypes[0] = 0;
        int i22 = 1;
        while (i22 < colNames.length) {
            colNames[i22] = "perm_" + i22;
            colTypes[i22] = 1;
            ++i22;
        }
        FArray i22 = inputArrray;
        DataFrame permResult = new DataFrame(i22.attributes.length - 1, colNames.length);
        permResult.setColNames((String[])var1_1);
        permResult.setColTypes((short[])var2_2);
        permResult.setColumn(0, fArray.getColNames(false));
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static double getCutoff(double alpha, double[] values) {
        void var0_1;
        void var2_2;
        void var3_3;
        double pValue = DiscFunctions.andersonDarlingNormTest(values);
        System.out.println("Anderson-Darling normality test p-value = " + DiscFunctions.format((double)var3_3, 7));
        double[] confidence = DiscFunctions.getConfidenceInterval(alpha, (double[])var2_2);
        System.out.println("Confidence Interval: " + DiscFunctions.format(confidence[0], 7) + " ; " + DiscFunctions.format(confidence[1], 7));
        return (double)var0_1[1];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getCutoffValues(int[] cutoffValues) {
        int[] nArray;
        Integer[] integerArray;
        void var1_1;
        Arrays.sort(cutoffValues);
        HashSet<Integer> vset = new HashSet<Integer>();
        int i = 0;
        while (i <= 0) {
            vset.add(cutoffValues[0]);
            ++i;
        }
        vset.removeAll(Arrays.asList(0));
        Integer[] tmpArray = new Integer[1];
        tmpArray = vset.toArray(tmpArray);
        cutoffValues = ArrayUtils.Integer2int(tmpArray);
        Arrays.sort(cutoffValues);
        vset.add(Math.round((float)cutoffValues[0] * 0.75f));
        vset.add(Math.round((float)cutoffValues[0] * 0.5f));
        vset.add(Math.round((float)cutoffValues[0] * 0.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.5f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 2.0f));
        integerArray = (Integer[])var1_1.toArray(integerArray);
        cutoffValues = ArrayUtils.Integer2int(integerArray);
        Arrays.sort(cutoffValues);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame calc_pValues$662b6a5a(DataFrame permutationRIValues, float[] valuesRI) {
        void var2_2;
        void var1_1;
        DataFrame dataFrame;
        String[] colNames = permutationRIValues.getColNames();
        boolean[] colNamesMask = new boolean[colNames.length];
        int permNumber = 0;
        int i = 0;
        while (i < colNames.length) {
            if (colNames[i].startsWith("perm_")) {
                colNamesMask[i] = true;
                ++permNumber;
            } else {
                colNamesMask[i] = false;
            }
            ++i;
        }
        float[] mean = new float[permutationRIValues.rows()];
        float[] normality_p = new float[permutationRIValues.rows()];
        float[] ttest_p = new float[permutationRIValues.rows()];
        int i2 = 0;
        while (i2 < permutationRIValues.rows()) {
            Object[] row = permutationRIValues.getRow(i2);
            double[] permRI = new double[permNumber];
            int currPermIdx = 0;
            int j = 0;
            while (j < row.length) {
                if (colNamesMask[j]) {
                    permRI[currPermIdx++] = ((Float)row[j]).floatValue();
                }
                ++j;
            }
            mean[i2] = (float)MathUtils.avg(permRI);
            normality_p[i2] = (float)DiscFunctions.andersonDarlingNormTest(permRI);
            double d = valuesRI[i2];
            double[] dArray = permRI;
            double d2 = (MathUtils.avg(permRI) - d) / (MathUtils.stdev(dArray) / Math.sqrt(dArray.length));
            double d3 = 2.0 * Probability.studentT((double)(dArray.length - 1), (double)(-Math.abs(d2)));
            ttest_p[i2] = (float)d3;
            ++i2;
        }
        DataFrame p_values = new DataFrame(dataFrame.rows(), 4);
        p_values.setColNames(new String[]{"mean", "RI_norm", "normality_test_p", "t_test_p"});
        p_values.setColTypes(new short[]{1, 1, 1, 1});
        p_values.setColumn(0, mean);
        p_values.setColumn(1, (float[])var1_1);
        p_values.setColumn(2, (float[])var2_2);
        p_values.setColumn(3, ttest_p);
        return p_values;
    }
}

