/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.list.AbstractLongList;
import cern.colt.list.MinMaxNumberList;
import java.util.Arrays;

public class DistinctNumberList
extends AbstractLongList {
    protected long[] distinctValues;
    protected MinMaxNumberList elements;

    public DistinctNumberList(long[] lArray, int n) {
        this.setUp(lArray, n);
    }

    public void add(long l) {
        this.elements.add(this.codeOf(l));
        ++this.size;
    }

    protected int codeOf(long l) {
        int n = Arrays.binarySearch(this.distinctValues, l);
        if (n < 0) {
            throw new IllegalArgumentException("Element=" + l + " not contained in distinct elements.");
        }
        return n;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public long getQuick(int n) {
        return this.distinctValues[(int)this.elements.getQuick(n)];
    }

    public void removeFromTo(int n, int n2) {
        this.elements.removeFromTo(n, n2);
        this.size -= n2 - n + 1;
    }

    public void setQuick(int n, long l) {
        this.elements.setQuick(n, this.codeOf(l));
    }

    protected void setSizeRaw(int n) {
        super.setSizeRaw(n);
        this.elements.setSizeRaw(n);
    }

    protected void setUp(long[] lArray, int n) {
        this.distinctValues = lArray;
        this.elements = new MinMaxNumberList(0L, lArray.length - 1, n);
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }
}

