/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.IntIntIntProcedure;
import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.ObjectMatrix2DProcedure;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix3D
extends AbstractMatrix3D {
    protected ObjectMatrix3D() {
    }

    public Object aggregate(ObjectObjectFunction objectObjectFunction, ObjectFunction objectFunction) {
        if (this.size() == 0) {
            return null;
        }
        Object object = objectFunction.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns - n;
                while (--n4 >= 0) {
                    object = objectObjectFunction.apply(object, objectFunction.apply(this.getQuick(n2, n3, n4)));
                }
                n = 0;
            }
        }
        return object;
    }

    public Object aggregate(ObjectMatrix3D objectMatrix3D, ObjectObjectFunction objectObjectFunction, ObjectObjectFunction objectObjectFunction2) {
        this.checkShape(objectMatrix3D);
        if (this.size() == 0) {
            return null;
        }
        Object object = objectObjectFunction2.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1), objectMatrix3D.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns - n;
                while (--n4 >= 0) {
                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.getQuick(n2, n3, n4), objectMatrix3D.getQuick(n2, n3, n4)));
                }
                n = 0;
            }
        }
        return object;
    }

    public ObjectMatrix3D assign(Object[][][] objectArray) {
        if (objectArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + objectArray.length + "slices()=" + this.slices());
        }
        int n = this.slices;
        while (--n >= 0) {
            Object[][] objectArray2 = objectArray[n];
            if (objectArray2.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray2.length + "rows()=" + this.rows());
            }
            int n2 = this.rows;
            while (--n2 >= 0) {
                Object[] objectArray3 = objectArray2[n2];
                if (objectArray3.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                }
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, objectArray3[n3]);
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectFunction objectFunction) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, objectFunction.apply(this.getQuick(n, n2, n3)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D == this) {
            return this;
        }
        this.checkShape(objectMatrix3D);
        if (this.haveSharedCells(objectMatrix3D)) {
            objectMatrix3D = objectMatrix3D.copy();
        }
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, objectMatrix3D.getQuick(n, n2, n3));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D, ObjectObjectFunction objectObjectFunction) {
        this.checkShape(objectMatrix3D);
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, objectObjectFunction.apply(this.getQuick(n, n2, n3), objectMatrix3D.getQuick(n, n2, n3)));
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(Object object) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, object);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns;
                while (--n4 >= 0) {
                    if (this.getQuick(n2, n3, n4) == null) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public ObjectMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectMatrix3D)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectMatrix3D objectMatrix3D = (ObjectMatrix3D)object;
        if (this.rows != objectMatrix3D.rows()) {
            return false;
        }
        if (this.columns != objectMatrix3D.columns()) {
            return false;
        }
        if (!bl) {
            int n = this.slices;
            while (--n >= 0) {
                int n2 = this.rows;
                while (--n2 >= 0) {
                    int n3 = this.columns;
                    while (--n3 >= 0) {
                        if (this.getQuick(n, n2, n3) == objectMatrix3D.getQuick(n, n2, n3)) continue;
                        return false;
                    }
                }
            }
        } else {
            int n = this.slices;
            while (--n >= 0) {
                int n4 = this.rows;
                while (--n4 >= 0) {
                    int n5 = this.columns;
                    while (--n5 >= 0) {
                        if (this.getQuick(n, n4, n5) != null ? this.getQuick(n, n4, n5).equals(objectMatrix3D.getQuick(n, n4, n5)) : objectMatrix3D.getQuick(n, n4, n5) == null) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Object get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    protected ObjectMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ObjectArrayList objectArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        objectArrayList.clear();
        int n = this.slices;
        int n2 = this.rows;
        int n3 = this.columns;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    Object object = this.getQuick(i, j, k);
                    if (object == null) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    objectArrayList.add(object);
                }
            }
        }
    }

    public abstract Object getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D == null) {
            return false;
        }
        if (this == objectMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(objectMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        return false;
    }

    public ObjectMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract ObjectMatrix3D like(int var1, int var2, int var3);

    protected abstract ObjectMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int n, int n2, int n3, Object object) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, object);
    }

    public abstract void setQuick(int var1, int var2, int var3, Object var4);

    public Object[][][] toArray() {
        Object[][][] objectArray = new Object[this.slices][this.rows][this.columns];
        int n = this.slices;
        while (--n >= 0) {
            Object[][] objectArray2 = objectArray[n];
            int n2 = this.rows;
            while (--n2 >= 0) {
                Object[] objectArray3 = objectArray2[n2];
                int n3 = this.columns;
                while (--n3 >= 0) {
                    objectArray3[n3] = this.getQuick(n, n2, n3);
                }
            }
        }
        return objectArray;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix3D view() {
        return (ObjectMatrix3D)this.clone();
    }

    public ObjectMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewColumnFlip() {
        return (ObjectMatrix3D)this.view().vColumnFlip();
    }

    public ObjectMatrix3D viewDice(int n, int n2, int n3) {
        return (ObjectMatrix3D)this.view().vDice(n, n2, n3);
    }

    public ObjectMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (ObjectMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public ObjectMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewRowFlip() {
        return (ObjectMatrix3D)this.view().vRowFlip();
    }

    public ObjectMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray4[n2] = this._sliceOffset(this._sliceRank(nArray[n2]));
        }
        n2 = nArray2.length;
        while (--n2 >= 0) {
            nArray5[n2] = this._rowOffset(this._rowRank(nArray2[n2]));
        }
        n2 = nArray3.length;
        while (--n2 >= 0) {
            nArray6[n2] = this._columnOffset(this._columnRank(nArray3[n2]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public ObjectMatrix3D viewSelection(ObjectMatrix2DProcedure objectMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!objectMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    protected abstract ObjectMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public ObjectMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public ObjectMatrix3D viewSliceFlip() {
        return (ObjectMatrix3D)this.view().vSliceFlip();
    }

    public ObjectMatrix3D viewSorted(int n, int n2) {
        return Sorting.mergeSort.sort(this, n, n2);
    }

    public ObjectMatrix3D viewStrides(int n, int n2, int n3) {
        return (ObjectMatrix3D)this.view().vStrides(n, n2, n3);
    }

    private boolean xforEach(ObjectProcedure objectProcedure) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    if (objectProcedure.apply(this.getQuick(n, n2, n3))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean xforEachCoordinate(IntIntIntProcedure intIntIntProcedure) {
        int n = this.columns;
        while (--n >= 0) {
            int n2 = this.slices;
            while (--n2 >= 0) {
                int n3 = this.rows;
                while (--n3 >= 0) {
                    if (intIntIntProcedure.apply(n2, n3, n)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

