/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleSet;

import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexSet;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.complex.complexLinks.ComplexLinks;
import dmLab.classifier.adx.selector.SelectorList;

public final class RuleSet {
    public ComplexSet[] complexSetArray;
    public ComplexLinks complexLinks = null;
    protected int decValIndex;
    private ADXParams adxParams;
    public boolean verbose = true;
    public boolean debug = false;

    /*
     * WARNING - void declaration
     */
    public RuleSet(int maxComplexLength, ADXParams adxParams) {
        void var2_2;
        void var1_1;
        this.complexSetArray = new ComplexSet[var1_1];
        this.adxParams = var2_2;
    }

    public final boolean createRules(FArray array, SelectorList selectorList, int decisionValIndex) {
        this.decValIndex = decisionValIndex;
        if (this.adxParams.keepMinimalSet && this.adxParams.searchBeam < selectorList.size()) {
            if (this.verbose) {
                System.out.print("Deleting surplus selectors...");
            }
            selectorList.deleteInsignificant(this.adxParams.searchBeam, this.adxParams.qMethod);
            if (this.verbose) {
                System.out.println(" Done. Current selectors base size: " + selectorList.size());
            }
        }
        FArray fArray = array;
        this.complexSetArray[0] = new ComplexSet(selectorList, this.adxParams, fArray.attributes.length);
        if (this.adxParams.debug) {
            System.out.println("### DEBUG INFO\n" + this.complexSetArray[0].toString(selectorList, array));
        }
        int currentComplexLength = 1;
        while (currentComplexLength < this.complexSetArray.length) {
            if (this.verbose) {
                System.out.println("Iteration " + currentComplexLength + " of " + (this.complexSetArray.length - 1));
            }
            double minQuality = this.complexSetArray[currentComplexLength - 1].findSignificantQuality();
            int toReproduce = this.complexSetArray[currentComplexLength - 1].selectComplexesToReproduce(minQuality);
            if (this.verbose) {
                System.out.println("Complexes to reproducing: " + toReproduce);
            }
            if (toReproduce == 0) break;
            if (this.verbose) {
                System.out.print("Generating complexes candidates (size=" + currentComplexLength + ")...");
            }
            FArray fArray2 = array;
            this.complexSetArray[currentComplexLength] = new ComplexSet(selectorList, this.complexSetArray[currentComplexLength - 1], this.adxParams, fArray2.attributes.length);
            this.complexSetArray[currentComplexLength].verbose = this.verbose;
            if (this.verbose) {
                System.out.println(this.complexSetArray[currentComplexLength].size() + " Complexes generated.");
            }
            if (this.testStopCriteria(currentComplexLength)) break;
            if (this.verbose) {
                System.out.println("Evaluating complexes candidates...");
            }
            this.complexSetArray[currentComplexLength].evaluate$1594a9c8(array, decisionValIndex);
            if (this.verbose) {
                System.out.println(this.complexSetArray[currentComplexLength].size() + " Complexes evaluated.");
            }
            if (this.adxParams.debug) {
                System.out.println("### DEBUG INFO - candidates\n" + this.complexSetArray[currentComplexLength].toString(selectorList, array));
            }
            if (this.verbose) {
                System.out.print("Clenaning candidates...");
            }
            this.complexSetArray[currentComplexLength].cleanCandidatesSet(selectorList, this.adxParams);
            if (this.verbose) {
                System.out.println(" Done. Current complexes (size=" + currentComplexLength + ") number is " + this.complexSetArray[currentComplexLength].size());
            }
            if (this.adxParams.debug) {
                System.out.println("### DEBUG INFO - after cleaning\n" + this.complexSetArray[currentComplexLength].toString(selectorList, array));
            }
            if (this.testStopCriteria(currentComplexLength)) break;
            if (this.adxParams.keepMinimalSet && this.adxParams.searchBeam < this.complexSetArray[currentComplexLength].size()) {
                double d = this.complexSetArray[currentComplexLength].findSignificantQuality();
                if (this.verbose) {
                    System.out.print("Deleting surplus complexes...");
                }
                this.complexSetArray[currentComplexLength].deleteComplexesQLess(d);
                if (this.verbose) {
                    System.out.println(" Done. Current complexes (size=" + currentComplexLength + ") number is " + this.complexSetArray[currentComplexLength].size());
                }
            }
            ++currentComplexLength;
        }
        return true;
    }

    private boolean testStopCriteria(int currentComplexLength) {
        if (this.complexSetArray[currentComplexLength].size() == 0) {
            if (this.verbose) {
                System.out.println("Stop criterion has been met.");
            }
            this.complexSetArray[var1_1] = null;
            return true;
        }
        return false;
    }

    public final void mergeRules(SelectorList selectorList, FArray array) {
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                if (this.debug) {
                    System.out.println("### DEBUG INFO - before merging\n" + this.complexSetArray[i].toString(selectorList, array));
                }
                this.complexSetArray[i].mergeComplexes(selectorList, array);
                if (this.debug) {
                    System.out.println("### DEBUG INFO - after merging\n" + this.complexSetArray[i].toString(selectorList, array));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(SelectorList selectorsList, FArray array) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        tmp.append("#Rules for decision = " + array.getDecValuesStr()[this.decValIndex]).append('\n');
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                tmp.append(this.complexSetArray[i].toString(selectorsList, array));
            }
            ++i;
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final double calcScore(SelectorList selectorsList, FArray array, int eventIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.complexLinks.calcScore((SelectorList)var1_1, (FArray)var2_2, (int)var3_3, this.adxParams);
    }

    public final boolean createLinks(ADXParams adxParams) {
        RuleSet ruleSet = this;
        int n = 0;
        int n2 = 0;
        while (n2 < ruleSet.complexSetArray.length) {
            if (ruleSet.complexSetArray[n2] != null) {
                n += ruleSet.complexSetArray[n2].size();
            }
            ++n2;
        }
        ComplexLink[] links = new ComplexLink[n];
        int link = 0;
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                int size = this.complexSetArray[i].size();
                int j = 0;
                while (j < size) {
                    Complex complex = this.complexSetArray[i].getComplex(j);
                    links[link++] = new ComplexLink(complex, i, j, this.complexSetArray[i].getComplex(j).calcQuality(adxParams.qMethodFinal));
                    ++j;
                }
            }
            ++i;
        }
        this.complexLinks = new ComplexLinks((ComplexLink[])ruleSet);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesQLess(double minQuality) {
        void var3_2;
        int removed = 0;
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                removed += this.complexSetArray[i].deleteComplexesQLess(minQuality);
            }
            if (this.complexSetArray[i] != null && this.complexSetArray[i].size() == 0) {
                this.complexSetArray[i] = null;
            }
            ++i;
        }
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesPosLessNeg() {
        void var1_1;
        int removed = 0;
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                removed += this.complexSetArray[i].deleteComplexesPosLessNeg();
            }
            if (this.complexSetArray[i] != null && this.complexSetArray[i].size() == 0) {
                this.complexSetArray[i] = null;
            }
            ++i;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesCoversNeg() {
        void var1_1;
        int removed = 0;
        int i = 0;
        while (i < this.complexSetArray.length) {
            if (this.complexSetArray[i] != null) {
                this.complexSetArray[i].deleteComplexesCoversNeg();
                ++removed;
            }
            if (this.complexSetArray[i] != null && this.complexSetArray[i].size() == 0) {
                this.complexSetArray[i] = null;
            }
            ++i;
        }
        return (int)var1_1;
    }
}

