/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassList;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.Tree.Node;
import dmLab.classifier.sliq.Tree.Tree;
import java.util.ArrayList;

final class SliqTree
extends Tree {
    private ArrayList<Node> leafs;
    private int classProxiesNumber;

    /*
     * WARNING - void declaration
     */
    public SliqTree(ClassList classList) {
        void var1_1;
        this.root = new SliqNode(classList.getProxiesNumber());
        this.leafs = new ArrayList();
        this.leafs.add(this.root);
        this.classProxiesNumber = var1_1.getProxiesNumber();
    }

    public final int getLeafsSize() {
        return this.leafs.size();
    }

    /*
     * WARNING - void declaration
     */
    public final SliqNode getLeaf(int leafIndex) {
        void var1_1;
        return (SliqNode)this.leafs.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private float calcNodeChildGiniIndex(SliqNode node, boolean attrType, boolean child) {
        float eventsNumber = node.getEventsNumber();
        boolean bl = child;
        int n = attrType;
        Object object = node;
        SliqTree sliqTree = this;
        int n2 = 0;
        object = n != 0 ? (Object)((SliqNode)object).numericHistogram.getHistogramArray(bl) : (Object)((SliqNode)object).nominalHistogram.getHistogramArray(bl);
        n = 0;
        while (n < sliqTree.classProxiesNumber) {
            n2 += object[n];
            ++n;
        }
        float childEventsNumber = n2;
        float sum = 0.0f;
        if (childEventsNumber > 0.0f) {
            void var3_3;
            int[] histArray;
            histArray = attrType != 0 ? node.numericHistogram.getHistogramArray(child) : histArray.nominalHistogram.getHistogramArray((boolean)var3_3);
            int classProxyIndex = 0;
            while (classProxyIndex < this.classProxiesNumber) {
                sum = (float)((double)sum + Math.pow((float)histArray[classProxyIndex] / childEventsNumber, 2.0));
                ++classProxyIndex;
            }
            return childEventsNumber / eventsNumber * (1.0f - sum);
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public final float getGoodnessOfSplit(SliqNode node, boolean attrType) {
        void var2_2;
        void var1_1;
        return node.getDiversityMeasure() - (this.calcNodeChildGiniIndex(node, attrType, true) + this.calcNodeChildGiniIndex((SliqNode)var1_1, (boolean)var2_2, false));
    }

    /*
     * WARNING - void declaration
     */
    public final void calcFreqClassGiniPurity(SliqNode node, ClassList classList) {
        void var1_1;
        void var2_2;
        void var3_3;
        int nonZeroClassProxyIndex = 0;
        int maxFreq = 0;
        int classMaxFreqIndex = 0;
        node.setEventsNumber(0);
        float sum = 0.0f;
        int classProxyIndex = 0;
        while (classProxyIndex < this.classProxiesNumber) {
            node.incEventsNumber(node.classFrequencies[classProxyIndex]);
            if (node.classFrequencies[classProxyIndex] > 0) {
                ++nonZeroClassProxyIndex;
            }
            if (node.classFrequencies[classProxyIndex] > maxFreq) {
                maxFreq = node.classFrequencies[classProxyIndex];
                classMaxFreqIndex = classProxyIndex;
            }
            ++classProxyIndex;
        }
        if (var3_3 >= 2) {
            node.setLeafIndicator(false);
        } else {
            node.setLeafIndicator(true);
        }
        classProxyIndex = 0;
        while (classProxyIndex < this.classProxiesNumber) {
            sum = (float)((double)sum + Math.pow((float)node.classFrequencies[classProxyIndex] / (float)node.getEventsNumber(), 2.0));
            ++classProxyIndex;
        }
        node.setDiversityMeasure(1.0f - sum);
        node.setNodeClass(var2_2.getClassProxy(classMaxFreqIndex));
        node.setErrorsNumber(var1_1.getEventsNumber() - maxFreq);
    }

    /*
     * WARNING - void declaration
     */
    public final float[] findBestSubset(SliqNode node, AttributeList attributeList) {
        void var1_1;
        int tmpLenght;
        String binarySubset;
        Object object = node;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = ((SliqNode)object).nominalHistogram.getAttrProxiesNumber();
        object = ((SliqNode)object).nominalHistogram.getAttrProxiesSummaryArray(false);
        int n2 = 0;
        while (n2 < n) {
            if (object[n2] > 0) {
                arrayList.add(n2);
            }
            ++n2;
        }
        ArrayList<Integer> compactHist = arrayList;
        int compactAttrProxiesNumber = compactHist.size();
        int NumberOfSubsets = (int)Math.pow(2.0, (double)compactAttrProxiesNumber - 1.0);
        int bestSubsetIndex = 0;
        int maxLength = 0;
        int subsetIndex = 1;
        while (subsetIndex < NumberOfSubsets) {
            float f;
            binarySubset = Integer.toBinaryString(subsetIndex);
            int length = binarySubset.length();
            tmpLenght = 0;
            int i = 0;
            while (i < length) {
                if (binarySubset.charAt(i) == '1') {
                    node.nominalHistogram.updateToLeft((Integer)compactHist.get(compactAttrProxiesNumber - (length - 1 - i) - 1));
                    ++tmpLenght;
                }
                ++i;
            }
            float tmpGoodness = this.getGoodnessOfSplit(node, false);
            if (f > node.tmpGoodnessOfSplit) {
                node.tmpGoodnessOfSplit = tmpGoodness;
                bestSubsetIndex = subsetIndex;
                maxLength = tmpLenght;
            }
            node.nominalHistogram.allToRight();
            ++subsetIndex;
        }
        float[] subset = new float[maxLength];
        binarySubset = Integer.toBinaryString(bestSubsetIndex);
        int n3 = binarySubset.length();
        tmpLenght = 0;
        int i = 0;
        while (i < n3) {
            if (binarySubset.charAt(i) == '1') {
                subset[tmpLenght] = attributeList.getAttrProxyValue((Integer)compactHist.get(compactAttrProxiesNumber - (n3 - 1 - i) - 1));
                ++tmpLenght;
            }
            ++i;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void createLeafs(ClassList classList) {
        SliqTree sliqTree = this;
        int leafsNumber = sliqTree.leafs.size();
        ArrayList<Object> tmpLeafs = new ArrayList<Object>();
        int leafIndex = 0;
        while (leafIndex < leafsNumber) {
            SliqNode node = this.getLeaf(leafIndex);
            if (node.getSplittingAttrIndex() == -1) {
                node.setLeafIndicator(true);
            }
            if (!node.getLeafIndicator()) {
                node.left = new SliqNode(classList.getProxiesNumber());
                node.right = new SliqNode(classList.getProxiesNumber());
                tmpLeafs.add(node.left);
                tmpLeafs.add(node.right);
            } else {
                void var3_6;
                tmpLeafs.add(var3_6);
            }
            ++leafIndex;
        }
        this.leafs = tmpLeafs;
    }
}

