/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class EditableBayesNet
extends BayesNet {
    static final long serialVersionUID = 746037443258735954L;
    protected FastVector m_nPositionX;
    protected FastVector m_nPositionY;
    protected FastVector m_fMarginP;
    protected FastVector m_nEvidence;
    static final int TEST = 0;
    static final int EXECUTE = 1;
    FastVector m_undoStack = new FastVector();
    int m_nCurrentEditAction = -1;
    int m_nSavedPointer = -1;
    boolean m_bNeedsUndoAction = true;

    public EditableBayesNet() {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
    }

    public EditableBayesNet(Instances instances) {
        try {
            if (instances.classIndex() < 0) {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            this.m_Instances = this.normalizeDataSet(instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int nNodes = this.getNrOfNodes();
        this.m_ParentSets = new ParentSet[nNodes];
        int i = 0;
        while (i < nNodes) {
            this.m_ParentSets[i] = new ParentSet();
            ++i;
        }
        this.m_Distributions = new Estimator[nNodes][];
        int iNode = 0;
        while (iNode < nNodes) {
            this.m_Distributions[iNode] = new Estimator[1];
            this.m_Distributions[iNode][0] = new DiscreteEstimatorBayes(this.getCardinality(iNode), 0.5);
            ++iNode;
        }
        this.m_nEvidence = new FastVector(nNodes);
        i = 0;
        while (i < nNodes) {
            this.m_nEvidence.addElement(-1);
            ++i;
        }
        this.m_fMarginP = new FastVector(nNodes);
        i = 0;
        while (i < nNodes) {
            double[] P = new double[this.getCardinality(i)];
            this.m_fMarginP.addElement(P);
            ++i;
        }
        this.m_nPositionX = new FastVector(nNodes);
        this.m_nPositionY = new FastVector(nNodes);
        iNode = 0;
        while (iNode < nNodes) {
            this.m_nPositionX.addElement(iNode % 10 * 50);
            this.m_nPositionY.addElement(iNode / 10 * 50);
            ++iNode;
        }
    }

    public EditableBayesNet(BIFReader other) {
        this.m_Instances = other.m_Instances;
        this.m_ParentSets = other.getParentSets();
        this.m_Distributions = other.getDistributions();
        int nNodes = this.getNrOfNodes();
        this.m_nPositionX = new FastVector(nNodes);
        this.m_nPositionY = new FastVector(nNodes);
        int i = 0;
        while (i < nNodes) {
            this.m_nPositionX.addElement(other.m_nPositionX[i]);
            this.m_nPositionY.addElement(other.m_nPositionY[i]);
            ++i;
        }
        this.m_nEvidence = new FastVector(nNodes);
        i = 0;
        while (i < nNodes) {
            this.m_nEvidence.addElement(-1);
            ++i;
        }
        this.m_fMarginP = new FastVector(nNodes);
        i = 0;
        while (i < nNodes) {
            double[] P = new double[this.getCardinality(i)];
            this.m_fMarginP.addElement(P);
            ++i;
        }
        this.clearUndoStack();
    }

    public EditableBayesNet(boolean bSetInstances) {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
        if (bSetInstances) {
            this.m_Instances = new Instances("New Network", new FastVector(0), 0);
        }
    }

    public void setData(Instances instances) throws Exception {
        int[] order = new int[this.getNrOfNodes()];
        int iNode = 0;
        while (iNode < this.getNrOfNodes()) {
            String sName = this.getNodeName(iNode);
            int nNode = 0;
            while (nNode < this.getNrOfNodes() && !sName.equals(instances.attribute(nNode).name())) {
                ++nNode;
            }
            if (nNode >= this.getNrOfNodes()) {
                throw new Exception("Cannot find node named [[[" + sName + "]]] in the data");
            }
            order[iNode] = nNode;
            ++iNode;
        }
        Reorder reorderFilter = new Reorder();
        reorderFilter.setAttributeIndicesArray(order);
        reorderFilter.setInputFormat(instances);
        instances = Filter.useFilter(instances, reorderFilter);
        Instances newInstances = new Instances(this.m_Instances, 0);
        if (this.m_DiscretizeFilter == null && this.m_MissingValuesFilter == null) {
            newInstances = this.normalizeDataSet(instances);
        } else {
            int iInstance = 0;
            while (iInstance < instances.numInstances()) {
                newInstances.add(this.normalizeInstance(instances.instance(iInstance)));
                ++iInstance;
            }
        }
        int iNode2 = 0;
        while (iNode2 < this.getNrOfNodes()) {
            if (newInstances.attribute(iNode2).numValues() != this.getCardinality(iNode2)) {
                throw new Exception("Number of values of node [[[" + this.getNodeName(iNode2) + "]]] differs in (discretized) dataset.");
            }
            ++iNode2;
        }
        this.m_Instances = newInstances;
    }

    public int getNode2(String sNodeName) {
        int iNode = 0;
        while (iNode < this.m_Instances.numAttributes()) {
            if (this.m_Instances.attribute(iNode).name().equals(sNodeName)) {
                return iNode;
            }
            ++iNode;
        }
        return -1;
    }

    public int getNode(String sNodeName) throws Exception {
        int iNode = this.getNode2(sNodeName);
        if (iNode < 0) {
            throw new Exception("Could not find node [[" + sNodeName + "]]");
        }
        return iNode;
    }

    public void addNode(String sName, int nCardinality) throws Exception {
        this.addNode(sName, nCardinality, 100 + this.getNrOfNodes() * 10, 100 + this.getNrOfNodes() * 10);
    }

    public void addNode(String sName, int nCardinality, int nPosX, int nPosY) throws Exception {
        if (this.getNode2(sName) >= 0) {
            this.addNode(String.valueOf(sName) + "x", nCardinality);
            return;
        }
        FastVector values = new FastVector(nCardinality);
        int iValue = 0;
        while (iValue < nCardinality) {
            values.addElement("Value" + (iValue + 1));
            ++iValue;
        }
        Attribute att = new Attribute(sName, values);
        this.m_Instances.insertAttributeAt(att, this.m_Instances.numAttributes());
        int nAtts = this.m_Instances.numAttributes();
        ParentSet[] parentSets = new ParentSet[nAtts];
        int iParentSet = 0;
        while (iParentSet < nAtts - 1) {
            parentSets[iParentSet] = this.m_ParentSets[iParentSet];
            ++iParentSet;
        }
        parentSets[nAtts - 1] = new ParentSet();
        this.m_ParentSets = parentSets;
        Estimator[][] distributions = new Estimator[nAtts][];
        int iNode = 0;
        while (iNode < nAtts - 1) {
            distributions[iNode] = this.m_Distributions[iNode];
            ++iNode;
        }
        distributions[nAtts - 1] = new Estimator[1];
        distributions[nAtts - 1][0] = new DiscreteEstimatorBayes(nCardinality, 0.5);
        this.m_Distributions = distributions;
        this.m_nPositionX.addElement(nPosX);
        this.m_nPositionY.addElement(nPosY);
        this.m_nEvidence.addElement(-1);
        double[] fMarginP = new double[nCardinality];
        int iValue2 = 0;
        while (iValue2 < nCardinality) {
            fMarginP[iValue2] = 1.0 / (double)nCardinality;
            ++iValue2;
        }
        this.m_fMarginP.addElement(fMarginP);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddNodeAction(sName, nCardinality, nPosX, nPosY));
        }
    }

    public void deleteNode(String sName) throws Exception {
        int nTargetNode = this.getNode(sName);
        this.deleteNode(nTargetNode);
    }

    public void deleteNode(int nTargetNode) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteNodeAction(nTargetNode));
        }
        int nAtts = this.m_Instances.numAttributes() - 1;
        int nTargetCard = this.m_Instances.attribute(nTargetNode).numValues();
        Estimator[][] distributions = new Estimator[nAtts][];
        int iNode = 0;
        while (iNode < nAtts) {
            int iNode2 = iNode;
            if (iNode >= nTargetNode) {
                ++iNode2;
            }
            Estimator[] distribution = this.m_Distributions[iNode2];
            if (this.m_ParentSets[iNode2].contains(nTargetNode)) {
                int nParentCard = this.m_ParentSets[iNode2].getCardinalityOfParents();
                Estimator[] distribution2 = new Estimator[nParentCard /= nTargetCard];
                int iParent = 0;
                while (iParent < nParentCard) {
                    distribution2[iParent] = distribution[iParent];
                    ++iParent;
                }
                distribution = distribution2;
            }
            distributions[iNode] = distribution;
            ++iNode;
        }
        this.m_Distributions = distributions;
        ParentSet[] parentSets = new ParentSet[nAtts];
        int iParentSet = 0;
        while (iParentSet < nAtts) {
            int iParentSet2 = iParentSet;
            if (iParentSet >= nTargetNode) {
                ++iParentSet2;
            }
            ParentSet parentset = this.m_ParentSets[iParentSet2];
            parentset.deleteParent(nTargetNode, this.m_Instances);
            int iParent = 0;
            while (iParent < parentset.getNrOfParents()) {
                int nParent = parentset.getParent(iParent);
                if (nParent > nTargetNode) {
                    parentset.SetParent(iParent, nParent - 1);
                }
                ++iParent;
            }
            parentSets[iParentSet] = parentset;
            ++iParentSet;
        }
        this.m_ParentSets = parentSets;
        this.m_Instances.setClassIndex(-1);
        this.m_Instances.deleteAttributeAt(nTargetNode);
        this.m_Instances.setClassIndex(nAtts - 1);
        this.m_nPositionX.removeElementAt(nTargetNode);
        this.m_nPositionY.removeElementAt(nTargetNode);
        this.m_nEvidence.removeElementAt(nTargetNode);
        this.m_fMarginP.removeElementAt(nTargetNode);
    }

    public void deleteSelection(FastVector nodes) {
        int i = 0;
        while (i < nodes.size()) {
            int j = i + 1;
            while (j < nodes.size()) {
                if ((Integer)nodes.elementAt(i) > (Integer)nodes.elementAt(j)) {
                    int h = (Integer)nodes.elementAt(i);
                    nodes.setElementAt(nodes.elementAt(j), i);
                    nodes.setElementAt(h, j);
                }
                ++j;
            }
            ++i;
        }
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteSelectionAction(nodes));
        }
        boolean bNeedsUndoAction = this.m_bNeedsUndoAction;
        this.m_bNeedsUndoAction = false;
        try {
            int iNode = nodes.size() - 1;
            while (iNode >= 0) {
                this.deleteNode((Integer)nodes.elementAt(iNode));
                --iNode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_bNeedsUndoAction = bNeedsUndoAction;
    }

    FastVector selectElements(Node item, String sElement) throws Exception {
        NodeList children = item.getChildNodes();
        FastVector nodelist = new FastVector();
        int iNode = 0;
        while (iNode < children.getLength()) {
            Node node = children.item(iNode);
            if (node.getNodeType() == 1 && node.getNodeName().equals(sElement)) {
                nodelist.addElement(node);
            }
            ++iNode;
        }
        return nodelist;
    }

    public String getContent(Element node) {
        String result = "";
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node item = list.item(i);
            if (item.getNodeType() == 3) {
                result = String.valueOf(result) + "\n" + item.getNodeValue();
            }
            ++i;
        }
        return result;
    }

    Element getDefinition(Document doc, String sName) throws Exception {
        NodeList nodelist = doc.getElementsByTagName("DEFINITION");
        int iNode = 0;
        while (iNode < nodelist.getLength()) {
            Node forNode;
            Node node = nodelist.item(iNode);
            FastVector list = this.selectElements(node, "FOR");
            if (list.size() > 0 && this.getContent((Element)(forNode = (Node)list.elementAt(0))).trim().equals(sName)) {
                return (Element)node;
            }
            ++iNode;
        }
        throw new Exception("Could not find definition for ((" + sName + "))");
    }

    public void paste(String sXML) throws Exception {
        this.paste(sXML, 0);
        this.paste(sXML, 1);
    }

    void paste(String sXML, int mode) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        Document doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(sXML)));
        doc.normalize();
        NodeList nodelist = doc.getElementsByTagName("VARIABLE");
        FastVector sBaseNames = new FastVector();
        Instances instances = new Instances(this.m_Instances, 0);
        int nBase = instances.numAttributes();
        int iNode = 0;
        while (iNode < nodelist.getLength()) {
            FastVector valueslist = this.selectElements(nodelist.item(iNode), "OUTCOME");
            int nValues = valueslist.size();
            FastVector nomStrings = new FastVector(nValues + 1);
            int iValue = 0;
            while (iValue < nValues) {
                Node node = ((Node)valueslist.elementAt(iValue)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (sValue == null) {
                    sValue = "Value" + (iValue + 1);
                }
                nomStrings.addElement(sValue);
                ++iValue;
            }
            FastVector nodelist2 = this.selectElements(nodelist.item(iNode), "NAME");
            if (nodelist2.size() == 0) {
                throw new Exception("No name specified for variable");
            }
            String sBaseName = ((CharacterData)((Node)nodelist2.elementAt(0)).getFirstChild()).getData();
            sBaseNames.addElement(sBaseName);
            String sNodeName = sBaseName;
            if (this.getNode2(sNodeName) >= 0) {
                sNodeName = "Copy of " + sBaseName;
            }
            int iAttempt = 2;
            while (this.getNode2(sNodeName) >= 0) {
                sNodeName = "Copy (" + iAttempt + ") of " + sBaseName;
                ++iAttempt;
            }
            Attribute att = new Attribute(sNodeName, nomStrings);
            instances.insertAttributeAt(att, instances.numAttributes());
            valueslist = this.selectElements(nodelist.item(iNode), "PROPERTY");
            nValues = valueslist.size();
            int nPosX = iAttempt * 10;
            int nPosY = iAttempt * 10;
            int iValue2 = 0;
            while (iValue2 < nValues) {
                Node node = ((Node)valueslist.elementAt(iValue2)).getFirstChild();
                String sValue = ((CharacterData)node).getData();
                if (sValue.startsWith("position")) {
                    int i0 = sValue.indexOf(40);
                    int i1 = sValue.indexOf(44);
                    int i2 = sValue.indexOf(41);
                    String sX = sValue.substring(i0 + 1, i1).trim();
                    String sY = sValue.substring(i1 + 1, i2).trim();
                    try {
                        nPosX = Integer.parseInt(sX) + iAttempt * 10;
                        nPosY = Integer.parseInt(sY) + iAttempt * 10;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Wrong number format in position :(" + sX + "," + sY + ")");
                    }
                }
                ++iValue2;
            }
            if (mode == 1) {
                this.m_nPositionX.addElement(nPosX);
                this.m_nPositionY.addElement(nPosY);
            }
            ++iNode;
        }
        Estimator[][] distributions = new Estimator[nBase + sBaseNames.size()][];
        ParentSet[] parentsets = new ParentSet[nBase + sBaseNames.size()];
        int iNode2 = 0;
        while (iNode2 < nBase) {
            distributions[iNode2] = this.m_Distributions[iNode2];
            parentsets[iNode2] = this.m_ParentSets[iNode2];
            ++iNode2;
        }
        if (mode == 1) {
            this.m_Instances = instances;
        }
        iNode2 = 0;
        while (iNode2 < sBaseNames.size()) {
            String sName = (String)sBaseNames.elementAt(iNode2);
            Element definition = this.getDefinition(doc, sName);
            parentsets[nBase + iNode2] = new ParentSet();
            FastVector nodelist2 = this.selectElements(definition, "GIVEN");
            int iParent = 0;
            while (iParent < nodelist2.size()) {
                Node parentName = ((Node)nodelist2.elementAt(iParent)).getFirstChild();
                String sParentName = ((CharacterData)parentName).getData();
                int nParent = -1;
                int iBase = 0;
                while (iBase < sBaseNames.size()) {
                    if (sParentName.equals((String)sBaseNames.elementAt(iBase))) {
                        nParent = nBase + iBase;
                    }
                    ++iBase;
                }
                if (nParent < 0) {
                    nParent = this.getNode(sParentName);
                }
                parentsets[nBase + iNode2].addParent(nParent, instances);
                ++iParent;
            }
            int nCardinality = parentsets[nBase + iNode2].getCardinalityOfParents();
            int nValues = instances.attribute(nBase + iNode2).numValues();
            distributions[nBase + iNode2] = new Estimator[nCardinality];
            int i = 0;
            while (i < nCardinality) {
                distributions[nBase + iNode2][i] = new DiscreteEstimatorBayes(nValues, 0.0);
                ++i;
            }
            String sTable = this.getContent((Element)this.selectElements(definition, "TABLE").elementAt(0));
            sTable = sTable.replaceAll("\\n", " ");
            StringTokenizer st = new StringTokenizer(sTable.toString());
            int i2 = 0;
            while (i2 < nCardinality) {
                DiscreteEstimatorBayes d = (DiscreteEstimatorBayes)distributions[nBase + iNode2][i2];
                int iValue = 0;
                while (iValue < nValues) {
                    String sWeight = st.nextToken();
                    d.addValue(iValue, new Double(sWeight));
                    ++iValue;
                }
                ++i2;
            }
            if (mode == 1) {
                this.m_nEvidence.insertElementAt(-1, nBase + iNode2);
                this.m_fMarginP.insertElementAt(new double[this.getCardinality(nBase + iNode2)], nBase + iNode2);
            }
            ++iNode2;
        }
        if (mode == 1) {
            this.m_Distributions = distributions;
            this.m_ParentSets = parentsets;
        }
        if (mode == 1 && this.m_bNeedsUndoAction) {
            this.addUndoAction(new PasteAction(sXML, nBase));
        }
    }

    public void addArc(String sParent, String sChild) throws Exception {
        int nParent = this.getNode(sParent);
        int nChild = this.getNode(sChild);
        this.addArc(nParent, nChild);
    }

    public void addArc(int nParent, int nChild) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(nParent, nChild));
        }
        int nOldCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        this.m_ParentSets[nChild].addParent(nParent, this.m_Instances);
        int nNewCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        Estimator[] ds = new Estimator[nNewCard];
        int iParent = 0;
        while (iParent < nNewCard) {
            ds[iParent] = Estimator.clone(this.m_Distributions[nChild][iParent % nOldCard]);
            ++iParent;
        }
        this.m_Distributions[nChild] = ds;
    }

    public void addArc(String sParent, FastVector nodes) throws Exception {
        int nParent = this.getNode(sParent);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(nParent, nodes));
        }
        boolean bNeedsUndoAction = this.m_bNeedsUndoAction;
        this.m_bNeedsUndoAction = false;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.addArc(nParent, nNode);
            ++iNode;
        }
        this.m_bNeedsUndoAction = bNeedsUndoAction;
    }

    public void deleteArc(String sParent, String sChild) throws Exception {
        int nParent = this.getNode(sParent);
        int nChild = this.getNode(sChild);
        this.deleteArc(nParent, nChild);
    }

    public void deleteArc(int nParent, int nChild) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteArcAction(nParent, nChild));
        }
        int nParentCard = this.m_ParentSets[nChild].getCardinalityOfParents();
        int nTargetCard = this.m_Instances.attribute(nChild).numValues();
        Estimator[] distribution2 = new Estimator[nParentCard /= nTargetCard];
        int iParent = 0;
        while (iParent < nParentCard) {
            distribution2[iParent] = this.m_Distributions[nChild][iParent];
            ++iParent;
        }
        this.m_Distributions[nChild] = distribution2;
        this.m_ParentSets[nChild].deleteParent(nParent, this.m_Instances);
    }

    public void setDistribution(String sName, double[][] P) throws Exception {
        int nTargetNode = this.getNode(sName);
        this.setDistribution(nTargetNode, P);
    }

    public void setDistribution(int nTargetNode, double[][] P) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new SetDistributionAction(nTargetNode, P));
        }
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        int iParent = 0;
        while (iParent < distributions.length) {
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(P[0].length, 0.0);
            int iValue = 0;
            while (iValue < distribution.getNumSymbols()) {
                distribution.addValue(iValue, P[iParent][iValue]);
                ++iValue;
            }
            distributions[iParent] = distribution;
            ++iParent;
        }
    }

    public double[][] getDistribution(String sName) {
        int nTargetNode = this.getNode2(sName);
        return this.getDistribution(nTargetNode);
    }

    public double[][] getDistribution(int nTargetNode) {
        int nParentCard = this.m_ParentSets[nTargetNode].getCardinalityOfParents();
        int nCard = this.m_Instances.attribute(nTargetNode).numValues();
        double[][] P = new double[nParentCard][nCard];
        int iParent = 0;
        while (iParent < nParentCard) {
            int iValue = 0;
            while (iValue < nCard) {
                P[iParent][iValue] = this.m_Distributions[nTargetNode][iParent].getProbability(iValue);
                ++iValue;
            }
            ++iParent;
        }
        return P;
    }

    public String[] getValues(String sName) {
        int nTargetNode = this.getNode2(sName);
        return this.getValues(nTargetNode);
    }

    public String[] getValues(int nTargetNode) {
        String[] values = new String[this.getCardinality(nTargetNode)];
        int iValue = 0;
        while (iValue < values.length) {
            values[iValue] = this.m_Instances.attribute(nTargetNode).value(iValue);
            ++iValue;
        }
        return values;
    }

    public String getValueName(int nTargetNode, int iValue) {
        return this.m_Instances.attribute(nTargetNode).value(iValue);
    }

    public void setNodeName(int nTargetNode, String sName) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameAction(nTargetNode, this.getNodeName(nTargetNode), sName));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector values = new FastVector(nCardinality);
        int iValue = 0;
        while (iValue < nCardinality) {
            values.addElement(att.value(iValue));
            ++iValue;
        }
        this.replaceAtt(nTargetNode, sName, values);
    }

    public void renameNodeValue(int nTargetNode, String sValue, String sNewValue) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameValueAction(nTargetNode, sValue, sNewValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector values = new FastVector(nCardinality);
        int iValue = 0;
        while (iValue < nCardinality) {
            if (att.value(iValue).equals(sValue)) {
                values.addElement(sNewValue);
            } else {
                values.addElement(att.value(iValue));
            }
            ++iValue;
        }
        this.replaceAtt(nTargetNode, att.name(), values);
    }

    public void addNodeValue(int nTargetNode, String sNewValue) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddValueAction(nTargetNode, sNewValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector values = new FastVector(nCardinality);
        int iValue = 0;
        while (iValue < nCardinality) {
            values.addElement(att.value(iValue));
            ++iValue;
        }
        values.addElement(sNewValue);
        this.replaceAtt(nTargetNode, att.name(), values);
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        int nNewCard = values.size();
        int iParent = 0;
        while (iParent < distributions.length) {
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nNewCard, 0.0);
            int iValue2 = 0;
            while (iValue2 < nNewCard - 1) {
                distribution.addValue(iValue2, distributions[iParent].getProbability(iValue2));
                ++iValue2;
            }
            distributions[iParent] = distribution;
            ++iParent;
        }
        int iNode = 0;
        while (iNode < this.getNrOfNodes()) {
            if (this.m_ParentSets[iNode].contains(nTargetNode)) {
                distributions = this.m_Distributions[iNode];
                ParentSet parentSet = this.m_ParentSets[iNode];
                int nParentCard = parentSet.getFreshCardinalityOfParents(this.m_Instances);
                Estimator[] newDistributions = new Estimator[nParentCard];
                int nCard = this.getCardinality(iNode);
                int nParents = parentSet.getNrOfParents();
                int[] values2 = new int[nParents];
                int iOldPos = 0;
                int iTargetNode = 0;
                while (parentSet.getParent(iTargetNode) != nTargetNode) {
                    ++iTargetNode;
                }
                int iPos = 0;
                while (iPos < nParentCard) {
                    int i;
                    DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nCard, 0.0);
                    int iValue3 = 0;
                    while (iValue3 < nCard) {
                        distribution.addValue(iValue3, distributions[iOldPos].getProbability(iValue3));
                        ++iValue3;
                    }
                    newDistributions[iPos] = distribution;
                    int n = i = 0;
                    values2[n] = values2[n] + 1;
                    while (i < nParents && values2[i] == this.getCardinality(parentSet.getParent(i))) {
                        values2[i] = 0;
                        if (++i >= nParents) continue;
                        int n2 = i;
                        values2[n2] = values2[n2] + 1;
                    }
                    if (values2[iTargetNode] != nNewCard - 1) {
                        ++iOldPos;
                    }
                    ++iPos;
                }
                this.m_Distributions[iNode] = newDistributions;
            }
            ++iNode;
        }
    }

    public void delNodeValue(int nTargetNode, String sValue) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DelValueAction(nTargetNode, sValue));
        }
        Attribute att = this.m_Instances.attribute(nTargetNode);
        int nCardinality = att.numValues();
        FastVector values = new FastVector(nCardinality);
        int nValue = -1;
        int iValue = 0;
        while (iValue < nCardinality) {
            if (att.value(iValue).equals(sValue)) {
                nValue = iValue;
            } else {
                values.addElement(att.value(iValue));
            }
            ++iValue;
        }
        if (nValue < 0) {
            throw new Exception("Node " + nTargetNode + " does not have value (" + sValue + ")");
        }
        this.replaceAtt(nTargetNode, att.name(), values);
        Estimator[] distributions = this.m_Distributions[nTargetNode];
        int nCard = values.size();
        int iParent = 0;
        while (iParent < distributions.length) {
            DiscreteEstimatorBayes distribution = new DiscreteEstimatorBayes(nCard, 0.0);
            double sum = 0.0;
            int iValue2 = 0;
            while (iValue2 < nCard) {
                sum += distributions[iParent].getProbability(iValue2);
                ++iValue2;
            }
            if (sum > 0.0) {
                iValue2 = 0;
                while (iValue2 < nCard) {
                    distribution.addValue(iValue2, distributions[iParent].getProbability(iValue2) / sum);
                    ++iValue2;
                }
            } else {
                iValue2 = 0;
                while (iValue2 < nCard) {
                    distribution.addValue(iValue2, 1.0 / (double)nCard);
                    ++iValue2;
                }
            }
            distributions[iParent] = distribution;
            ++iParent;
        }
        int iNode = 0;
        while (iNode < this.getNrOfNodes()) {
            if (this.m_ParentSets[iNode].contains(nTargetNode)) {
                ParentSet parentSet = this.m_ParentSets[iNode];
                distributions = this.m_Distributions[iNode];
                Estimator[] newDistributions = new Estimator[distributions.length * nCard / (nCard + 1)];
                int iCurrentDist = 0;
                int nParents = parentSet.getNrOfParents();
                int[] values2 = new int[nParents];
                int nParentCard = parentSet.getFreshCardinalityOfParents(this.m_Instances) * (nCard + 1) / nCard;
                int iTargetNode = 0;
                while (parentSet.getParent(iTargetNode) != nTargetNode) {
                    ++iTargetNode;
                }
                int[] nCards = new int[nParents];
                int iParent2 = 0;
                while (iParent2 < nParents) {
                    nCards[iParent2] = this.getCardinality(parentSet.getParent(iParent2));
                    ++iParent2;
                }
                int n = iTargetNode;
                nCards[n] = nCards[n] + 1;
                int iPos = 0;
                while (iPos < nParentCard) {
                    int i;
                    if (values2[iTargetNode] != nValue) {
                        newDistributions[iCurrentDist++] = distributions[iPos];
                    }
                    int n2 = i = 0;
                    values2[n2] = values2[n2] + 1;
                    while (i < nParents && values2[i] == nCards[i]) {
                        values2[i] = 0;
                        if (++i >= nParents) continue;
                        int n3 = i;
                        values2[n3] = values2[n3] + 1;
                    }
                    ++iPos;
                }
                this.m_Distributions[iNode] = newDistributions;
            }
            ++iNode;
        }
        if (this.getEvidence(nTargetNode) > nValue) {
            this.setEvidence(nTargetNode, this.getEvidence(nTargetNode) - 1);
        }
    }

    public void setPosition(int iNode, int nX, int nY) {
        if (this.m_bNeedsUndoAction) {
            boolean isUpdate = false;
            UndoAction undoAction = null;
            try {
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetPositionAction posAction = (SetPositionAction)undoAction;
                    if (posAction.m_nTargetNode == iNode) {
                        isUpdate = true;
                        posAction.setUndoPosition(nX, nY);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isUpdate) {
                this.addUndoAction(new SetPositionAction(iNode, nX, nY));
            }
        }
        this.m_nPositionX.setElementAt(nX, iNode);
        this.m_nPositionY.setElementAt(nY, iNode);
    }

    public void setPosition(int nNode, int nX, int nY, FastVector nodes) {
        int dX = nX - this.getPositionX(nNode);
        int dY = nY - this.getPositionY(nNode);
        if (this.m_bNeedsUndoAction) {
            boolean isUpdate = false;
            try {
                UndoAction undoAction = null;
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetGroupPositionAction posAction = (SetGroupPositionAction)undoAction;
                    isUpdate = true;
                    int iNode = 0;
                    while (isUpdate && iNode < posAction.m_nodes.size()) {
                        if ((Integer)posAction.m_nodes.elementAt(iNode) != (Integer)nodes.elementAt(iNode)) {
                            isUpdate = false;
                        }
                        ++iNode;
                    }
                    if (isUpdate) {
                        posAction.setUndoPosition(dX, dY);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isUpdate) {
                this.addUndoAction(new SetGroupPositionAction(nodes, dX, dY));
            }
        }
        int iNode = 0;
        while (iNode < nodes.size()) {
            nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(this.getPositionX(nNode) + dX, nNode);
            this.m_nPositionY.setElementAt(this.getPositionY(nNode) + dY, nNode);
            ++iNode;
        }
    }

    public void layoutGraph(FastVector nPosX, FastVector nPosY) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new LayoutGraphAction(nPosX, nPosY));
        }
        this.m_nPositionX = nPosX;
        this.m_nPositionY = nPosY;
    }

    public int getPositionX(int iNode) {
        return (Integer)this.m_nPositionX.elementAt(iNode);
    }

    public int getPositionY(int iNode) {
        return (Integer)this.m_nPositionY.elementAt(iNode);
    }

    public void alignLeft(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignLeftAction(nodes));
        }
        int nMinX = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX < nMinX || iNode == 0) {
                nMinX = nX;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(nMinX, nNode);
            ++iNode;
        }
    }

    public void alignRight(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignRightAction(nodes));
        }
        int nMaxX = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX > nMaxX || iNode == 0) {
                nMaxX = nX;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt(nMaxX, nNode);
            ++iNode;
        }
    }

    public void alignTop(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignTopAction(nodes));
        }
        int nMinY = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY < nMinY || iNode == 0) {
                nMinY = nY;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt(nMinY, nNode);
            ++iNode;
        }
    }

    public void alignBottom(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignBottomAction(nodes));
        }
        int nMaxY = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY > nMaxY || iNode == 0) {
                nMaxY = nY;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt(nMaxY, nNode);
            ++iNode;
        }
    }

    public void centerHorizontal(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerHorizontalAction(nodes));
        }
        int nMinY = -1;
        int nMaxY = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY < nMinY || iNode == 0) {
                nMinY = nY;
            }
            if (nY > nMaxY || iNode == 0) {
                nMaxY = nY;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt((nMinY + nMaxY) / 2, nNode);
            ++iNode;
        }
    }

    public void centerVertical(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerVerticalAction(nodes));
        }
        int nMinX = -1;
        int nMaxX = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX < nMinX || iNode == 0) {
                nMinX = nX;
            }
            if (nX > nMaxX || iNode == 0) {
                nMaxX = nX;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt((nMinX + nMaxX) / 2, nNode);
            ++iNode;
        }
    }

    public void spaceHorizontal(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceHorizontalAction(nodes));
        }
        int nMinX = -1;
        int nMaxX = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nX = this.getPositionX((Integer)nodes.elementAt(iNode));
            if (nX < nMinX || iNode == 0) {
                nMinX = nX;
            }
            if (nX > nMaxX || iNode == 0) {
                nMaxX = nX;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionX.setElementAt((int)((double)nMinX + (double)(iNode * (nMaxX - nMinX)) / ((double)nodes.size() - 1.0)), nNode);
            ++iNode;
        }
    }

    public void spaceVertical(FastVector nodes) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceVerticalAction(nodes));
        }
        int nMinY = -1;
        int nMaxY = -1;
        int iNode = 0;
        while (iNode < nodes.size()) {
            int nY = this.getPositionY((Integer)nodes.elementAt(iNode));
            if (nY < nMinY || iNode == 0) {
                nMinY = nY;
            }
            if (nY > nMaxY || iNode == 0) {
                nMaxY = nY;
            }
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            int nNode = (Integer)nodes.elementAt(iNode);
            this.m_nPositionY.setElementAt((int)((double)nMinY + (double)(iNode * (nMaxY - nMinY)) / ((double)nodes.size() - 1.0)), nNode);
            ++iNode;
        }
    }

    void replaceAtt(int nTargetNode, String sName, FastVector values) {
        Attribute newAtt = new Attribute(sName, values);
        if (this.m_Instances.classIndex() == nTargetNode) {
            this.m_Instances.setClassIndex(-1);
            this.m_Instances.deleteAttributeAt(nTargetNode);
            this.m_Instances.insertAttributeAt(newAtt, nTargetNode);
            this.m_Instances.setClassIndex(nTargetNode);
        } else {
            this.m_Instances.deleteAttributeAt(nTargetNode);
            this.m_Instances.insertAttributeAt(newAtt, nTargetNode);
        }
    }

    public double[] getMargin(int iNode) {
        return (double[])this.m_fMarginP.elementAt(iNode);
    }

    public void setMargin(int iNode, double[] fMarginP) {
        this.m_fMarginP.setElementAt(fMarginP, iNode);
    }

    public int getEvidence(int iNode) {
        return (Integer)this.m_nEvidence.elementAt(iNode);
    }

    public void setEvidence(int iNode, int iValue) {
        this.m_nEvidence.setElementAt(iValue, iNode);
    }

    public FastVector getChildren(int nTargetNode) {
        FastVector children = new FastVector();
        int iNode = 0;
        while (iNode < this.getNrOfNodes()) {
            if (this.m_ParentSets[iNode].contains(nTargetNode)) {
                children.addElement(iNode);
            }
            ++iNode;
        }
        return children;
    }

    @Override
    public String toXMLBIF03() {
        if (this.m_Instances == null) {
            return "<!--No model built yet-->";
        }
        StringBuffer text = new StringBuffer();
        text.append(this.getBIFHeader());
        text.append("\n");
        text.append("\n");
        text.append("<BIF VERSION=\"0.3\">\n");
        text.append("<NETWORK>\n");
        text.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        int iAttribute = 0;
        while (iAttribute < this.m_Instances.numAttributes()) {
            text.append("<VARIABLE TYPE=\"nature\">\n");
            text.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</NAME>\n");
            int iValue = 0;
            while (iValue < this.m_Instances.attribute(iAttribute).numValues()) {
                text.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).value(iValue)) + "</OUTCOME>\n");
                ++iValue;
            }
            text.append("<PROPERTY>position = (" + this.getPositionX(iAttribute) + "," + this.getPositionY(iAttribute) + ")</PROPERTY>\n");
            text.append("</VARIABLE>\n");
            ++iAttribute;
        }
        iAttribute = 0;
        while (iAttribute < this.m_Instances.numAttributes()) {
            text.append("<DEFINITION>\n");
            text.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(iAttribute).name()) + "</FOR>\n");
            int iParent = 0;
            while (iParent < this.m_ParentSets[iAttribute].getNrOfParents()) {
                text.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[iAttribute].getParent(iParent)).name()) + "</GIVEN>\n");
                ++iParent;
            }
            text.append("<TABLE>\n");
            iParent = 0;
            while (iParent < this.m_ParentSets[iAttribute].getCardinalityOfParents()) {
                int iValue = 0;
                while (iValue < this.m_Instances.attribute(iAttribute).numValues()) {
                    text.append(this.m_Distributions[iAttribute][iParent].getProbability(iValue));
                    text.append(' ');
                    ++iValue;
                }
                text.append('\n');
                ++iParent;
            }
            text.append("</TABLE>\n");
            text.append("</DEFINITION>\n");
            ++iAttribute;
        }
        text.append("</NETWORK>\n");
        text.append("</BIF>\n");
        return text.toString();
    }

    public String toXMLBIF03(FastVector nodes) {
        int nNode;
        StringBuffer text = new StringBuffer();
        text.append(this.getBIFHeader());
        text.append("\n");
        text.append("\n");
        text.append("<BIF VERSION=\"0.3\">\n");
        text.append("<NETWORK>\n");
        text.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        int iNode = 0;
        while (iNode < nodes.size()) {
            nNode = (Integer)nodes.elementAt(iNode);
            text.append("<VARIABLE TYPE=\"nature\">\n");
            text.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(nNode).name()) + "</NAME>\n");
            int iValue = 0;
            while (iValue < this.m_Instances.attribute(nNode).numValues()) {
                text.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(nNode).value(iValue)) + "</OUTCOME>\n");
                ++iValue;
            }
            text.append("<PROPERTY>position = (" + this.getPositionX(nNode) + "," + this.getPositionY(nNode) + ")</PROPERTY>\n");
            text.append("</VARIABLE>\n");
            ++iNode;
        }
        iNode = 0;
        while (iNode < nodes.size()) {
            nNode = (Integer)nodes.elementAt(iNode);
            text.append("<DEFINITION>\n");
            text.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(nNode).name()) + "</FOR>\n");
            int iParent = 0;
            while (iParent < this.m_ParentSets[nNode].getNrOfParents()) {
                text.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[nNode].getParent(iParent)).name()) + "</GIVEN>\n");
                ++iParent;
            }
            text.append("<TABLE>\n");
            iParent = 0;
            while (iParent < this.m_ParentSets[nNode].getCardinalityOfParents()) {
                int iValue = 0;
                while (iValue < this.m_Instances.attribute(nNode).numValues()) {
                    text.append(this.m_Distributions[nNode][iParent].getProbability(iValue));
                    text.append(' ');
                    ++iValue;
                }
                text.append('\n');
                ++iParent;
            }
            text.append("</TABLE>\n");
            text.append("</DEFINITION>\n");
            ++iNode;
        }
        text.append("</NETWORK>\n");
        text.append("</BIF>\n");
        return text.toString();
    }

    public boolean canUndo() {
        return this.m_nCurrentEditAction >= 0;
    }

    public boolean canRedo() {
        return this.m_nCurrentEditAction < this.m_undoStack.size() - 1;
    }

    public boolean isChanged() {
        return this.m_nCurrentEditAction != this.m_nSavedPointer;
    }

    public void isSaved() {
        this.m_nSavedPointer = this.m_nCurrentEditAction;
    }

    public String lastActionMsg() {
        if (this.m_undoStack.size() == 0) {
            return "";
        }
        return ((UndoAction)this.m_undoStack.lastElement()).getRedoMsg();
    }

    public String undo() {
        if (!this.canUndo()) {
            return "";
        }
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.undo();
        this.m_bNeedsUndoAction = true;
        --this.m_nCurrentEditAction;
        return undoAction.getUndoMsg();
    }

    public String redo() {
        if (!this.canRedo()) {
            return "";
        }
        ++this.m_nCurrentEditAction;
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.redo();
        this.m_bNeedsUndoAction = true;
        return undoAction.getRedoMsg();
    }

    void addUndoAction(UndoAction action) {
        int iAction = this.m_undoStack.size() - 1;
        while (iAction > this.m_nCurrentEditAction) {
            this.m_undoStack.removeElementAt(iAction--);
        }
        if (this.m_nSavedPointer > this.m_nCurrentEditAction) {
            this.m_nSavedPointer = -2;
        }
        this.m_undoStack.addElement(action);
        ++this.m_nCurrentEditAction;
    }

    public void clearUndoStack() {
        this.m_undoStack = new FastVector();
        this.m_nCurrentEditAction = -1;
        this.m_nSavedPointer = -1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7836 $");
    }

    public static void main(String[] args) {
    }

    class AddArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_children;
        int m_nParent;
        Estimator[][] m_CPT;

        AddArcAction(int nParent, int nChild) {
            try {
                this.m_nParent = nParent;
                this.m_children = new FastVector();
                this.m_children.addElement(nChild);
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                this.m_CPT = new Estimator[1][];
                this.m_CPT[0] = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        AddArcAction(int nParent, FastVector children) {
            try {
                this.m_nParent = nParent;
                this.m_children = new FastVector();
                this.m_CPT = new Estimator[children.size()][];
                int iChild = 0;
                while (iChild < children.size()) {
                    int nChild = (Integer)children.elementAt(iChild);
                    this.m_children.addElement(nChild);
                    SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                    this.m_CPT[iChild] = (Estimator[])so.getObject();
                    ++iChild;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                int iChild = 0;
                while (iChild < this.m_children.size()) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.deleteArc(this.m_nParent, nChild);
                    SerializedObject so = new SerializedObject(this.m_CPT[iChild]);
                    EditableBayesNet.this.m_Distributions[nChild] = (Estimator[])so.getObject();
                    ++iChild;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                int iChild = 0;
                while (iChild < this.m_children.size()) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.addArc(this.m_nParent, nChild);
                    ++iChild;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AddNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        String m_sName;
        int m_nPosX;
        int m_nPosY;
        int m_nCardinality;

        AddNodeAction(String sName, int nCardinality, int nPosX, int nPosY) {
            this.m_sName = sName;
            this.m_nCardinality = nCardinality;
            this.m_nPosX = nPosX;
            this.m_nPosY = nPosY;
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.deleteNode(EditableBayesNet.this.getNrOfNodes() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.addNode(this.m_sName, this.m_nCardinality, this.m_nPosX, this.m_nPosY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class AddValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;

        AddValueAction(int nTargetNode, String sValue) {
            this.m_nTargetNode = nTargetNode;
            this.m_sValue = sValue;
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            EditableBayesNet.this.addNodeValue(this.m_nTargetNode, this.m_sValue);
        }

        @Override
        public String getUndoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        @Override
        public String getRedoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class DelValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;
        Estimator[] m_CPT;
        FastVector m_children;
        Estimator[][] m_childAtts;
        Attribute m_att;

        DelValueAction(int nTargetNode, String sValue) {
            try {
                this.m_nTargetNode = nTargetNode;
                this.m_sValue = sValue;
                this.m_att = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                this.m_children = new FastVector();
                int iNode = 0;
                while (iNode < EditableBayesNet.this.getNrOfNodes()) {
                    if (EditableBayesNet.this.m_ParentSets[iNode].contains(nTargetNode)) {
                        this.m_children.addElement(iNode);
                    }
                    ++iNode;
                }
                this.m_childAtts = new Estimator[this.m_children.size()][];
                int iChild = 0;
                while (iChild < this.m_children.size()) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    this.m_childAtts[iChild] = EditableBayesNet.this.m_Distributions[nChild];
                    ++iChild;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])so.getObject();
                int iChild = 0;
                while (iChild < this.m_children.size()) {
                    int nChild = (Integer)this.m_children.elementAt(iChild);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                    so = new SerializedObject(this.m_childAtts[iChild]);
                    EditableBayesNet.this.m_Distributions[nChild] = (Estimator[])so.getObject();
                    ++iChild;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        @Override
        public String getRedoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class DeleteArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int[] m_nParents;
        int m_nChild;
        int m_nParent;
        Estimator[] m_CPT;

        DeleteArcAction(int nParent, int nChild) {
            try {
                this.m_nChild = nChild;
                this.m_nParent = nParent;
                this.m_nParents = new int[EditableBayesNet.this.getNrOfParents(nChild)];
                int iParent = 0;
                while (iParent < this.m_nParents.length) {
                    this.m_nParents[iParent] = EditableBayesNet.this.getParent(nChild, iParent);
                    ++iParent;
                }
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nChild]);
                this.m_CPT = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nChild] = (Estimator[])so.getObject();
                ParentSet parentSet = new ParentSet();
                int iParent = 0;
                while (iParent < this.m_nParents.length) {
                    parentSet.addParent(this.m_nParents[iParent], EditableBayesNet.this.m_Instances);
                    ++iParent;
                }
                ((EditableBayesNet)EditableBayesNet.this).m_ParentSets[this.m_nChild] = parentSet;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.deleteArc(this.m_nParent, this.m_nChild);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Attribute m_att;
        Estimator[] m_CPT;
        ParentSet m_ParentSet;
        FastVector m_deleteArcActions;
        int m_nPosX;
        int m_nPosY;

        DeleteNodeAction(int nTargetNode) {
            this.m_nTargetNode = nTargetNode;
            this.m_att = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
            try {
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                so = new SerializedObject(EditableBayesNet.this.m_ParentSets[nTargetNode]);
                this.m_ParentSet = (ParentSet)so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_deleteArcActions = new FastVector();
            int iNode = 0;
            while (iNode < EditableBayesNet.this.getNrOfNodes()) {
                if (EditableBayesNet.this.m_ParentSets[iNode].contains(nTargetNode)) {
                    this.m_deleteArcActions.addElement(new DeleteArcAction(nTargetNode, iNode));
                }
                ++iNode;
            }
            this.m_nPosX = EditableBayesNet.this.getPositionX(this.m_nTargetNode);
            this.m_nPosY = EditableBayesNet.this.getPositionY(this.m_nTargetNode);
        }

        @Override
        public void undo() {
            try {
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                int nAtts = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSets = new ParentSet[nAtts];
                int nX = 0;
                int iParentSet = 0;
                while (iParentSet < nAtts) {
                    if (iParentSet == this.m_nTargetNode) {
                        SerializedObject so = new SerializedObject(this.m_ParentSet);
                        parentSets[iParentSet] = (ParentSet)so.getObject();
                        nX = 1;
                    } else {
                        parentSets[iParentSet] = EditableBayesNet.this.m_ParentSets[iParentSet - nX];
                        int iParent = 0;
                        while (iParent < parentSets[iParentSet].getNrOfParents()) {
                            int nParent = parentSets[iParentSet].getParent(iParent);
                            if (nParent >= this.m_nTargetNode) {
                                parentSets[iParentSet].SetParent(iParent, nParent + 1);
                            }
                            ++iParent;
                        }
                    }
                    ++iParentSet;
                }
                EditableBayesNet.this.m_ParentSets = parentSets;
                Estimator[][] distributions = new Estimator[nAtts][];
                nX = 0;
                int iNode = 0;
                while (iNode < nAtts) {
                    if (iNode == this.m_nTargetNode) {
                        SerializedObject so = new SerializedObject(this.m_CPT);
                        distributions[iNode] = (Estimator[])so.getObject();
                        nX = 1;
                    } else {
                        distributions[iNode] = EditableBayesNet.this.m_Distributions[iNode - nX];
                    }
                    ++iNode;
                }
                EditableBayesNet.this.m_Distributions = distributions;
                int deletedArc = 0;
                while (deletedArc < this.m_deleteArcActions.size()) {
                    DeleteArcAction action = (DeleteArcAction)this.m_deleteArcActions.elementAt(deletedArc);
                    action.undo();
                    ++deletedArc;
                }
                EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX, this.m_nTargetNode);
                EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY, this.m_nTargetNode);
                EditableBayesNet.this.m_nEvidence.insertElementAt(-1, this.m_nTargetNode);
                EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(this.m_nTargetNode)], this.m_nTargetNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.deleteNode(this.m_nTargetNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteSelectionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        Attribute[] m_att;
        Estimator[][] m_CPT;
        ParentSet[] m_ParentSet;
        FastVector m_deleteArcActions;
        int[] m_nPosX;
        int[] m_nPosY;

        public DeleteSelectionAction(FastVector nodes) {
            this.m_nodes = new FastVector();
            int nNodes = nodes.size();
            this.m_att = new Attribute[nNodes];
            this.m_CPT = new Estimator[nNodes][];
            this.m_ParentSet = new ParentSet[nNodes];
            this.m_nPosX = new int[nNodes];
            this.m_nPosY = new int[nNodes];
            this.m_deleteArcActions = new FastVector();
            int iNode = 0;
            while (iNode < nodes.size()) {
                int nTargetNode = (Integer)nodes.elementAt(iNode);
                this.m_nodes.addElement(nTargetNode);
                this.m_att[iNode] = EditableBayesNet.this.m_Instances.attribute(nTargetNode);
                try {
                    SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                    this.m_CPT[iNode] = (Estimator[])so.getObject();
                    so = new SerializedObject(EditableBayesNet.this.m_ParentSets[nTargetNode]);
                    this.m_ParentSet[iNode] = (ParentSet)so.getObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_nPosX[iNode] = EditableBayesNet.this.getPositionX(nTargetNode);
                this.m_nPosY[iNode] = EditableBayesNet.this.getPositionY(nTargetNode);
                int iNode2 = 0;
                while (iNode2 < EditableBayesNet.this.getNrOfNodes()) {
                    if (!nodes.contains(iNode2) && EditableBayesNet.this.m_ParentSets[iNode2].contains(nTargetNode)) {
                        this.m_deleteArcActions.addElement(new DeleteArcAction(nTargetNode, iNode2));
                    }
                    ++iNode2;
                }
                ++iNode;
            }
        }

        @Override
        public void undo() {
            try {
                int iNode = 0;
                while (iNode < this.m_nodes.size()) {
                    int nTargetNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att[iNode], nTargetNode);
                    ++iNode;
                }
                int nAtts = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSets = new ParentSet[nAtts];
                int[] offset = new int[nAtts];
                int iNode2 = 0;
                while (iNode2 < nAtts) {
                    offset[iNode2] = iNode2;
                    ++iNode2;
                }
                iNode2 = this.m_nodes.size() - 1;
                while (iNode2 >= 0) {
                    int nTargetNode;
                    int i = nTargetNode = ((Integer)this.m_nodes.elementAt(iNode2)).intValue();
                    while (i < nAtts - 1) {
                        offset[i] = offset[i + 1];
                        ++i;
                    }
                    --iNode2;
                }
                int iTargetNode = 0;
                int iParentSet = 0;
                while (iParentSet < nAtts) {
                    if (iTargetNode < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(iTargetNode) == Integer.valueOf(iParentSet)) {
                        SerializedObject so = new SerializedObject(this.m_ParentSet[iTargetNode]);
                        parentSets[iParentSet] = (ParentSet)so.getObject();
                        ++iTargetNode;
                    } else {
                        parentSets[iParentSet] = EditableBayesNet.this.m_ParentSets[iParentSet - iTargetNode];
                        int iParent = 0;
                        while (iParent < parentSets[iParentSet].getNrOfParents()) {
                            int nParent = parentSets[iParentSet].getParent(iParent);
                            parentSets[iParentSet].SetParent(iParent, offset[nParent]);
                            ++iParent;
                        }
                    }
                    ++iParentSet;
                }
                EditableBayesNet.this.m_ParentSets = parentSets;
                Estimator[][] distributions = new Estimator[nAtts][];
                iTargetNode = 0;
                int iNode3 = 0;
                while (iNode3 < nAtts) {
                    if (iTargetNode < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(iTargetNode) == Integer.valueOf(iNode3)) {
                        SerializedObject so = new SerializedObject(this.m_CPT[iTargetNode]);
                        distributions[iNode3] = (Estimator[])so.getObject();
                        ++iTargetNode;
                    } else {
                        distributions[iNode3] = EditableBayesNet.this.m_Distributions[iNode3 - iTargetNode];
                    }
                    ++iNode3;
                }
                EditableBayesNet.this.m_Distributions = distributions;
                iNode3 = 0;
                while (iNode3 < this.m_nodes.size()) {
                    int nTargetNode = (Integer)this.m_nodes.elementAt(iNode3);
                    EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX[iNode3], nTargetNode);
                    EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY[iNode3], nTargetNode);
                    EditableBayesNet.this.m_nEvidence.insertElementAt(-1, nTargetNode);
                    EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(nTargetNode)], nTargetNode);
                    ++iNode3;
                }
                int deletedArc = 0;
                while (deletedArc < this.m_deleteArcActions.size()) {
                    DeleteArcAction action = (DeleteArcAction)this.m_deleteArcActions.elementAt(deletedArc);
                    action.undo();
                    ++deletedArc;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                int iNode = this.m_nodes.size() - 1;
                while (iNode >= 0) {
                    int nNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.deleteNode(nNode);
                    --iNode;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class LayoutGraphAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nPosX;
        FastVector m_nPosY;
        FastVector m_nPosX2;
        FastVector m_nPosY2;

        LayoutGraphAction(FastVector nPosX, FastVector nPosY) {
            this.m_nPosX = new FastVector(nPosX.size());
            this.m_nPosY = new FastVector(nPosX.size());
            this.m_nPosX2 = new FastVector(nPosX.size());
            this.m_nPosY2 = new FastVector(nPosX.size());
            int iNode = 0;
            while (iNode < nPosX.size()) {
                this.m_nPosX.addElement(EditableBayesNet.this.m_nPositionX.elementAt(iNode));
                this.m_nPosY.addElement(EditableBayesNet.this.m_nPositionY.elementAt(iNode));
                this.m_nPosX2.addElement(nPosX.elementAt(iNode));
                this.m_nPosY2.addElement(nPosY.elementAt(iNode));
                ++iNode;
            }
        }

        @Override
        public void undo() {
            int iNode = 0;
            while (iNode < this.m_nPosX.size()) {
                EditableBayesNet.this.setPosition(iNode, (Integer)this.m_nPosX.elementAt(iNode), (Integer)this.m_nPosY.elementAt(iNode));
                ++iNode;
            }
        }

        @Override
        public void redo() {
            int iNode = 0;
            while (iNode < this.m_nPosX.size()) {
                EditableBayesNet.this.setPosition(iNode, (Integer)this.m_nPosX2.elementAt(iNode), (Integer)this.m_nPosY2.elementAt(iNode));
                ++iNode;
            }
        }
    }

    class PasteAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nBase;
        String m_sXML;

        PasteAction(String sXML, int nBase) {
            this.m_sXML = sXML;
            this.m_nBase = nBase;
        }

        @Override
        public void undo() {
            try {
                int iNode = EditableBayesNet.this.getNrOfNodes() - 1;
                while (iNode >= this.m_nBase) {
                    EditableBayesNet.this.deleteNode(iNode);
                    --iNode;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.paste(this.m_sXML, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class RenameAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sNewName;
        String m_sOldName;

        RenameAction(int nTargetNode, String sOldName, String sNewName) {
            this.m_nTargetNode = nTargetNode;
            this.m_sNewName = sNewName;
            this.m_sOldName = sOldName;
        }

        @Override
        public void undo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sOldName);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sNewName);
        }
    }

    class RenameValueAction
    extends RenameAction {
        static final long serialVersionUID = 1L;

        RenameValueAction(int nTargetNode, String sOldName, String sNewName) {
            super(nTargetNode, sOldName, sNewName);
        }

        @Override
        public void undo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sNewName, this.m_sOldName);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sOldName, this.m_sNewName);
        }

        @Override
        public String getUndoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sNewName + " to " + this.m_sOldName;
        }

        @Override
        public String getRedoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sOldName + " to " + this.m_sNewName;
        }
    }

    class SetDistributionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Estimator[] m_CPT;
        double[][] m_P;

        SetDistributionAction(int nTargetNode, double[][] P) {
            try {
                this.m_nTargetNode = nTargetNode;
                SerializedObject so = new SerializedObject(EditableBayesNet.this.m_Distributions[nTargetNode]);
                this.m_CPT = (Estimator[])so.getObject();
                this.m_P = P;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void undo() {
            try {
                SerializedObject so = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])so.getObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.setDistribution(this.m_nTargetNode, this.m_P);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }

        @Override
        public String getRedoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }
    }

    class SetGroupPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        int m_dX;
        int m_dY;

        SetGroupPositionAction(FastVector nodes, int dX, int dY) {
            this.m_nodes = new FastVector(nodes.size());
            int iNode = 0;
            while (iNode < nodes.size()) {
                this.m_nodes.addElement(nodes.elementAt(iNode));
                ++iNode;
            }
            this.m_dX = dX;
            this.m_dY = dY;
        }

        @Override
        public void undo() {
            int iNode = 0;
            while (iNode < this.m_nodes.size()) {
                int nNode = (Integer)this.m_nodes.elementAt(iNode);
                EditableBayesNet.this.setPosition(nNode, EditableBayesNet.this.getPositionX(nNode) - this.m_dX, EditableBayesNet.this.getPositionY(nNode) - this.m_dY);
                ++iNode;
            }
        }

        @Override
        public void redo() {
            int iNode = 0;
            while (iNode < this.m_nodes.size()) {
                int nNode = (Integer)this.m_nodes.elementAt(iNode);
                EditableBayesNet.this.setPosition(nNode, EditableBayesNet.this.getPositionX(nNode) + this.m_dX, EditableBayesNet.this.getPositionY(nNode) + this.m_dY);
                ++iNode;
            }
        }

        public void setUndoPosition(int dX, int dY) {
            this.m_dX += dX;
            this.m_dY += dY;
        }
    }

    class SetPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        int m_nX;
        int m_nY;
        int m_nX2;
        int m_nY2;

        SetPositionAction(int nTargetNode, int nX, int nY) {
            this.m_nTargetNode = nTargetNode;
            this.m_nX2 = nX;
            this.m_nY2 = nY;
            this.m_nX = EditableBayesNet.this.getPositionX(nTargetNode);
            this.m_nY = EditableBayesNet.this.getPositionY(nTargetNode);
        }

        @Override
        public void undo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX, this.m_nY);
        }

        @Override
        public void redo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX2, this.m_nY2);
        }

        public void setUndoPosition(int nX, int nY) {
            this.m_nX2 = nX;
            this.m_nY2 = nY;
        }
    }

    class UndoAction
    implements Serializable {
        static final long serialVersionUID = 1L;

        UndoAction() {
        }

        public void undo() {
        }

        public void redo() {
        }

        public String getUndoMsg() {
            return this.getMsg();
        }

        public String getRedoMsg() {
            return this.getMsg();
        }

        String getMsg() {
            String sStr = this.toString();
            int iStart = sStr.indexOf(36);
            int iEnd = sStr.indexOf(64);
            StringBuffer sBuffer = new StringBuffer();
            int i = iStart + 1;
            while (i < iEnd) {
                char c = sStr.charAt(i);
                if (Character.isUpperCase(c)) {
                    sBuffer.append(' ');
                }
                sBuffer.append(sStr.charAt(i));
                ++i;
            }
            return sBuffer.toString();
        }
    }

    class alignAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        FastVector m_posX;
        FastVector m_posY;

        alignAction(FastVector nodes) {
            this.m_nodes = new FastVector(nodes.size());
            this.m_posX = new FastVector(nodes.size());
            this.m_posY = new FastVector(nodes.size());
            int iNode = 0;
            while (iNode < nodes.size()) {
                int nNode = (Integer)nodes.elementAt(iNode);
                this.m_nodes.addElement(nNode);
                this.m_posX.addElement(EditableBayesNet.this.getPositionX(nNode));
                this.m_posY.addElement(EditableBayesNet.this.getPositionY(nNode));
                ++iNode;
            }
        }

        @Override
        public void undo() {
            try {
                int iNode = 0;
                while (iNode < this.m_nodes.size()) {
                    int nNode = (Integer)this.m_nodes.elementAt(iNode);
                    EditableBayesNet.this.setPosition(nNode, (Integer)this.m_posX.elementAt(iNode), (Integer)this.m_posY.elementAt(iNode));
                    ++iNode;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class alignBottomAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignBottomAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignBottom(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the bottom.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the bottom.";
        }
    }

    class alignLeftAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignLeftAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignLeft(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the left.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the left.";
        }
    }

    class alignRightAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignRightAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignRight(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the right.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the right.";
        }
    }

    class alignTopAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignTopAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.alignTop(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the top.";
        }

        @Override
        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the top.";
        }
    }

    class centerHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerHorizontalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.centerHorizontal(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering horizontally.";
        }

        @Override
        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class centerVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerVerticalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.centerVertical(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering vertically.";
        }

        @Override
        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes vertically.";
        }
    }

    class spaceHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceHorizontalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.spaceHorizontal(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceing horizontally.";
        }

        @Override
        public String getRedoMsg() {
            return "spaceing " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class spaceVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceVerticalAction(FastVector nodes) {
            super(nodes);
        }

        @Override
        public void redo() {
            try {
                EditableBayesNet.this.spaceVertical(this.m_nodes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceng vertically.";
        }

        @Override
        public String getRedoMsg() {
            return "Spaceng " + this.m_nodes.size() + " nodes vertically.";
        }
    }
}

