/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.ChiSquare;
import jdistlib.matrix.QMatrixUtils;
import jdistlib.rng.RandomEngine;

public class Wishart {
    public static final double[][] random(double n, double[][] L, RandomEngine rand) {
        int d = L.length;
        assert (d == L[0].length);
        double[][] z = new double[d][d];
        double[] y = new double[d];
        double[][] B = new double[d][d];
        int i = 1;
        while (i < d) {
            int j = 0;
            while (j < i) {
                z[i][j] = rand.nextGaussian();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < d) {
            double sum = y[i] = ChiSquare.random(n - (double)i + 1.0, rand);
            int j = 0;
            while (j < i) {
                double val = z[j][i];
                sum += val * val;
                ++j;
            }
            B[i][i] = sum / n;
            if (i > 0) {
                double d2 = z[i][0] * Math.sqrt(y[0]) / n;
                B[i][0] = d2;
                B[0][i] = d2;
            }
            ++i;
        }
        i = 2;
        while (i < d) {
            int j = 1;
            while (j < i) {
                double sum = z[i][j] * Math.sqrt(y[j]);
                int k = 0;
                while (k < j) {
                    sum += z[i][k] * z[j][k];
                    ++k;
                }
                double d3 = sum / n;
                B[j][i] = d3;
                B[i][j] = d3;
                ++j;
            }
            ++i;
        }
        return QMatrixUtils.calculateXYt(QMatrixUtils.calculateXY(L, B), L);
    }
}

