/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.domain;

import dmLab.array.domain.ADXDomainSet;
import dmLab.array.domain.ADXDomainValue;
import dmLab.array.domain.Domain;

public final class ADXDomain
extends Domain
implements Cloneable {
    private ADXDomainSet domainSet;
    private float[] decValues;
    private int[] totalPosNumber;
    private int rows;

    /*
     * WARNING - void declaration
     */
    public final boolean createDomain(float[] discRanges, float[] column, float[] decColumn, float[] decValues) {
        int i;
        this.domainSet = new ADXDomainSet();
        this.decValues = decValues;
        this.rows = column.length;
        this.totalPosNumber = new int[decValues.length];
        if (column.length != decColumn.length) {
            System.err.print("Size of column is diffrent than size of decColumn!");
            return false;
        }
        if (discRanges != null) {
            i = 0;
            while (i < discRanges.length) {
                this.domainSet.addValue(new ADXDomainValue(discRanges[i], decValues.length));
                ++i;
            }
        }
        i = 0;
        while (i < this.rows) {
            int decisionIndex;
            int n;
            ADXDomainValue domainValue;
            block9: {
                domainValue = this.domainSet.getDomainValue(column[i]);
                if (domainValue == null) {
                    domainValue = new ADXDomainValue(column[i], decValues.length);
                    this.domainSet.addValue(domainValue);
                }
                float f = decColumn[i];
                ADXDomain aDXDomain = this;
                int n2 = 0;
                while (n2 < aDXDomain.decValues.length) {
                    if (aDXDomain.decValues[n2] == f) {
                        n = n2;
                        break block9;
                    }
                    ++n2;
                }
                n = decisionIndex = -1;
            }
            if (n != -1) {
                domainValue.incrementPosNumber(decisionIndex);
                int n3 = decisionIndex;
                this.totalPosNumber[n3] = this.totalPosNumber[n3] + 1;
            } else {
                void var1_1;
                var1_1.incrementCoveredNumber();
            }
            ++i;
        }
        return true;
    }

    @Override
    public final float[] getDomainValues() {
        return this.domainSet.getValues();
    }

    public final boolean contains(float value) {
        return this.domainSet.contains(Float.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalPositives(int decisionIndex) {
        void var1_1;
        return this.totalPosNumber[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalNegatives(int decisionIndex) {
        void var1_1;
        return this.rows - this.totalPosNumber[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final float posSupport(int valueIndex, int decisionIndex) {
        void var2_2;
        void var1_1;
        return this.domainSet.getDomainValue((int)var1_1).getPosNumber((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final float negSupport(int valueIndex, int decisionIndex) {
        void var2_2;
        void var1_1;
        return this.domainSet.getDomainValue((int)var1_1).getNegNumber((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final float posCoverage(int valueIndex, int decisionIndex) {
        void var2_2;
        void var1_1;
        return (float)this.domainSet.getDomainValue((int)var1_1).getPosNumber(decisionIndex) / (float)this.totalPosNumber[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public final float negCoverage(int valueIndex, int decisionIndex) {
        void var2_2;
        void var1_1;
        return (float)this.domainSet.getDomainValue((int)var1_1).getNegNumber(decisionIndex) / ((float)this.rows - (float)this.totalPosNumber[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    public final float coverage(int valueIndex, int decisionIndex) {
        void var2_3;
        void var1_1;
        float f = (float)this.domainSet.getDomainValue(valueIndex).getPosNumber(decisionIndex) + (float)this.domainSet.getDomainValue((int)var1_1).getNegNumber((int)var2_3);
        return f / (float)this.rows;
    }

    /*
     * WARNING - void declaration
     */
    public final float getValue(int valueIndex) {
        void var1_1;
        return this.domainSet.getDomainValue((int)var1_1).value;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(this.domainSet.toString());
        int i = 0;
        while (i < this.totalPosNumber.length) {
            tmp.append("totalPos: " + this.totalPosNumber[i]).append('\t');
            tmp.append("totalNeg: " + (this.rows - this.totalPosNumber[i])).append('\n');
            ++i;
        }
        tmp.append("#decision: " + this.decValues.length);
        return var1_1.toString();
    }

    public final boolean sort() {
        return this.domainSet.sort();
    }

    public final int size() {
        return this.domainSet.size();
    }

    public final int decisionsNumber() {
        return this.decValues.length;
    }

    public final boolean getData(float[] valuesArray, int[] positivesArray, int[] negativesArray, int decisionIndex) {
        int size = this.domainSet.size();
        if (valuesArray.length != size && positivesArray.length != size && negativesArray.length != size) {
            System.err.println("Size of array is different than domain size.");
            return false;
        }
        int i = 0;
        while (i < size) {
            ADXDomainValue domainValue = this.domainSet.getDomainValue(i);
            valuesArray[i] = domainValue.value;
            positivesArray[i] = domainValue.getPosNumber(0);
            negativesArray[i] = domainValue.getNegNumber(0);
            ++i;
        }
        return true;
    }
}

