/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.modules;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.PredictionResult;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.mcfsEngine.modules.Split;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import dmLab.utils.statList.StatsList;
import dmLab.utils.statList.StatsObject;
import java.util.Random;

public final class Projection {
    private MCFSParams mcfsParams;
    private Split split;
    private StatsList splitsStats;
    private DiscFunctions selectFunctions$49f14b5d;

    /*
     * WARNING - void declaration
     */
    public Projection(MCFSParams mcfsParams, Random random) {
        void var2_2;
        void var1_1;
        this.mcfsParams = mcfsParams;
        this.split = new Split((MCFSParams)var1_1, random);
        this.selectFunctions$49f14b5d = new DiscFunctions((Random)var2_2);
    }

    public final ConfusionMatrix projectionLoop(Classifier classifier, FArray inputArray, AttributesRI[] attrRI, AttributesID attrIDependencies) {
        ConfusionMatrix confusionMatrix;
        this.splitsStats = new StatsList();
        if (inputArray.isTargetNominal()) {
            confusionMatrix = new ConfusionMatrix(inputArray.getColNames(true)[inputArray.getDecAttrIdx()], inputArray.getDecValuesStr());
            this.splitsStats.addHeader$505d15af("acc,wAcc,errors");
        } else {
            confusionMatrix = null;
            this.splitsStats.addHeader$505d15af("pearson,MAE,RMSE,SMAPE");
        }
        int projectionSize = this.mcfsParams.projectionSizeValue;
        FArray fArray = inputArray;
        if (projectionSize >= fArray.attributes.length) {
            fArray = inputArray;
            projectionSize = fArray.attributes.length - 1;
        }
        int[] colMask = this.selectFunctions$49f14b5d.getColumnsMask(inputArray, projectionSize);
        FArray projectionArray = (FArray)DiscFunctions.selectColumns(inputArray, colMask);
        int i = 0;
        while (i < attrRI.length) {
            attrRI[i].addProjections(projectionArray);
            ++i;
        }
        int j = 0;
        while (j < this.mcfsParams.splits) {
            float[] stats;
            FArray balancedArray = projectionArray;
            if (this.mcfsParams.tmpBalancedClassSizes != null) {
                balancedArray = this.selectFunctions$49f14b5d.balanceClasses(projectionArray, this.mcfsParams.tmpBalancedClassSizes);
            }
            FArray limitedSizeArray = balancedArray;
            if (this.mcfsParams.splitSetSize > 0 && balancedArray.rowsNumber() > this.mcfsParams.splitSetSize) {
                limitedSizeArray = (FArray)this.selectFunctions$49f14b5d.selectRowsRandom(balancedArray, this.mcfsParams.splitSetSize);
            }
            PredictionResult predRes = this.split.splitLoop(classifier, limitedSizeArray, attrRI, attrIDependencies);
            if (inputArray.isTargetNominal()) {
                ConfusionMatrix matrix = predRes.confusionMatrix;
                confusionMatrix.add(matrix);
                stats = new float[]{(float)QualityMeasure.calcAcc(matrix.getMatrix()), (float)QualityMeasure.calcWAcc(matrix.getMatrix()), QualityMeasure.errors(matrix.getMatrix())};
                this.splitsStats.add(new StatsObject(stats));
            } else {
                stats = new float[]{(float)stats.getPredQuality(QualityMeasure.PEARSON), (float)stats.getPredQuality(QualityMeasure.MAE), (float)stats.getPredQuality(QualityMeasure.RMSE), (float)stats.getPredQuality(QualityMeasure.SMAPE)};
                this.splitsStats.add(new StatsObject(stats));
            }
            ++j;
        }
        return confusionMatrix;
    }

    public final StatsList getSplitsStats() {
        return this.splitsStats;
    }
}

