/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleFamily;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.ruleFamily.Coverage;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.ruleSet.SelectRules;
import dmLab.classifier.adx.selector.SelectorList;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public final class RuleFamily {
    private RuleSet[] ruleSetArray;
    public SelectorList[] selectorListArray;
    private FArray trainArray;
    private double[] classSensitivity;
    private ADXParams adxParams;
    private double[] scores;
    private float finalSelectionTime = 0.0f;
    public boolean verbose = false;

    public RuleFamily(int decisionValuesNumber, int maxComplexLength, ADXParams adxParams) {
        this.adxParams = adxParams;
        this.ruleSetArray = new RuleSet[decisionValuesNumber];
        this.selectorListArray = new SelectorList[decisionValuesNumber];
        this.classSensitivity = new double[decisionValuesNumber];
        Arrays.fill(this.classSensitivity, 1.0);
        int i = 0;
        while (i < this.ruleSetArray.length) {
            this.ruleSetArray[i] = new RuleSet(maxComplexLength, adxParams);
            this.selectorListArray[i] = new SelectorList();
            ++i;
        }
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean createRules(FArray trainArray) {
        float[] decisionValues = trainArray.getDecValues();
        int decisionValuesNumber = decisionValues.length;
        int eventNumber = trainArray.rowsNumber();
        this.trainArray = trainArray;
        this.init();
        int decValIndex = 0;
        while (decValIndex < decisionValuesNumber) {
            if (this.verbose) {
                System.out.println("-----> Building Rules for Decision: " + trainArray.attributes[trainArray.getDecAttrIdx()].name + "=" + trainArray.getDecValuesStr()[decValIndex] + " <-----");
            }
            this.selectorListArray[decValIndex] = new SelectorList();
            this.selectorListArray[decValIndex].verbose = this.verbose;
            if (this.verbose) {
                System.out.println("Creating selectors base...");
            }
            this.selectorListArray[decValIndex].createSelectorBase(trainArray, decValIndex);
            if (this.verbose) {
                System.out.println(" Selectors base created. Selectors base size = " + this.selectorListArray[decValIndex].size());
            }
            if (this.verbose) {
                System.out.println("Creating rules...");
            }
            this.ruleSetArray[decValIndex].createRules(trainArray, this.selectorListArray[decValIndex], decValIndex);
            this.ruleSetArray[decValIndex].deleteComplexesPosLessNeg();
            if (this.adxParams.mergeCondition != 0) {
                if (this.verbose) {
                    System.out.print("Merging rules...");
                }
                this.ruleSetArray[decValIndex].mergeRules(this.selectorListArray[decValIndex], trainArray);
                if (this.verbose) {
                    System.out.println(" Rules merged.");
                }
            }
            if (this.adxParams.useSensitivity == 1) {
                this.classSensitivity[decValIndex] = this.adxParams.getSensitivity(decValIndex);
            } else {
                FArray fArray = trainArray;
                double posEvents = fArray.getADXDomain(fArray.getDecAttrIdx()).getTotalPositives(decValIndex);
                this.classSensitivity[decValIndex] = posEvents / (double)eventNumber;
                if (this.verbose) {
                    System.out.println(" Probability of the class occurence = " + DiscFunctions.formatFloat(this.classSensitivity[decValIndex], 5));
                }
            }
            if (this.verbose) {
                System.out.print("Calculating Coverages...");
                Coverage coverage = RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]);
                RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]).precision = 5;
                System.out.println(coverage.toString());
            }
            long start = System.currentTimeMillis();
            SelectRules selectRules = new SelectRules();
            if (this.verbose) {
                System.out.print("Selecting significant rules...");
            }
            if (this.adxParams.selSignificantMethod == 0) {
                this.ruleSetArray[decValIndex].deleteComplexesCoversNeg();
            } else if (this.adxParams.selSignificantMethod == 1) {
                this.ruleSetArray[decValIndex].deleteComplexesPosLessNeg();
            } else if (this.adxParams.selSignificantMethod == 2) {
                this.ruleSetArray[decValIndex].deleteComplexesQLess(this.adxParams.qMin);
            } else if (this.adxParams.selSignificantMethod == 3) {
                SelectRules.selectFinalRuleSet(this.ruleSetArray[decValIndex], this.adxParams, this.adxParams.getFinalBeam(decValIndex));
            } else if (this.adxParams.selSignificantMethod == 4) {
                selectRules.selectMinFinalRuleSet_fast(this.ruleSetArray[decValIndex], trainArray, this.selectorListArray[decValIndex], this.adxParams, this.adxParams.getFinalBeam(decValIndex));
            } else {
                System.err.println("Incorrect adxParams.selSignificantMethod");
            }
            long stop = System.currentTimeMillis();
            this.finalSelectionTime += (float)(stop - start) / 1000.0f;
            if (this.verbose) {
                void var2_8;
                System.out.println(" Significant rules have been selected.");
                System.out.print("Calculating Coverages...");
                Coverage coverage = RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]);
                RuleFamily.calcCoverage(trainArray, this.ruleSetArray[decValIndex], this.selectorListArray[decValIndex], decisionValues[decValIndex]).precision = 5;
                System.out.println(var2_8.toString());
            }
            ++decValIndex;
        }
        return true;
    }

    public final void saveRuleFamily(String inputFileName) {
        int decisionValIndex = 0;
        while (decisionValIndex < this.trainArray.getDecValues().length) {
            block5: {
                FileWriter fileWriter;
                String string = String.valueOf(inputFileName) + "_" + this.trainArray.getDecValuesStr()[decisionValIndex];
                FArray fArray = this.trainArray;
                SelectorList selectorList = this.selectorListArray[decisionValIndex];
                RuleSet ruleSet = this.ruleSetArray[decisionValIndex];
                try {
                    fileWriter = new FileWriter(String.valueOf(string) + ".rls");
                }
                catch (IOException iOException) {
                    System.err.println("Error opening file. File: " + string + ".rls");
                    break block5;
                }
                try {
                    fileWriter.write(ruleSet.toString(selectorList, fArray));
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    System.err.println("Error writing file. File: " + string + ".rls");
                    iOException.printStackTrace();
                }
            }
            ++decisionValIndex;
        }
    }

    public final void prepareClassification() {
        int i = 0;
        while (i < this.ruleSetArray.length) {
            this.ruleSetArray[i].createLinks(this.adxParams);
            RuleSet ruleSet = this.ruleSetArray[i];
            ruleSet.complexLinks.calcGlobalParams$4379dc3a();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float classifyEvent2(FArray array, int eventIndex) {
        int n;
        block10: {
            int i;
            float[] decisionValues = array.getDecValues();
            this.scores = this.calcScores(array, eventIndex, false);
            if (this.adxParams.useSensitivity == 1 || this.adxParams.useSensitivity == 2) {
                int i2 = 0;
                while (i2 < this.scores.length) {
                    int n2 = i2;
                    this.scores[n2] = this.scores[n2] * this.classSensitivity[i2];
                    ++i2;
                }
            }
            int maxIndex = ArrayUtils.maxIndex(this.scores);
            if (this.adxParams.scoreMethod >= 6 && maxIndex == -1) {
                void var2_4;
                this.scores = this.calcScores(array, (int)var2_4, true);
                maxIndex = ArrayUtils.maxIndex(this.scores);
            }
            if ((float)maxIndex != -1.0f) {
                void var3_7;
                return (float)var3_7[maxIndex];
            }
            if (MathUtils.sum(this.scores) != 0.0) {
                i = 0;
                while (i < this.scores.length) {
                    int n3 = i;
                    this.scores[n3] = this.scores[n3] * this.classSensitivity[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.scores.length) {
                    this.scores[i] = this.classSensitivity[i];
                    ++i;
                }
            }
            double[] dArray = this.classSensitivity;
            double d = MathUtils.sum(this.classSensitivity);
            Random random = new Random();
            double d2 = random.nextDouble() * d;
            d = 0.0;
            int n4 = 0;
            while (n4 < dArray.length) {
                if (d2 <= (d += dArray[n4])) {
                    n = n4;
                    break block10;
                }
                ++n4;
            }
            n = -1;
        }
        int n5 = n;
        return n;
    }

    public final double[] getLastScores() {
        return this.scores;
    }

    private double[] calcScores(FArray array, int eventIndex, boolean useAlternativeScore) {
        double[] scores = new double[array.getDecValues().length];
        int i = 0;
        while (i < this.ruleSetArray.length) {
            scores[i] = !useAlternativeScore ? this.ruleSetArray[i].calcScore(this.selectorListArray[i], array, eventIndex) : this.ruleSetArray[i].complexLinks.alternativeScore;
            ++i;
        }
        return scores;
    }

    public final void saveSymbolicSelectors(String fileName) {
        int decisionValIndex = 0;
        while (decisionValIndex < this.selectorListArray.length) {
            this.selectorListArray[decisionValIndex].save(String.valueOf(fileName) + "_" + this.trainArray.getDecValuesStr()[decisionValIndex]);
            ++decisionValIndex;
        }
    }

    public final void saveSelectors(String fileName) {
        int decisionValIndex = 0;
        while (decisionValIndex < this.selectorListArray.length) {
            this.selectorListArray[decisionValIndex].save(String.valueOf(fileName) + "_" + this.trainArray.getDecValuesStr()[decisionValIndex], this.trainArray);
            ++decisionValIndex;
        }
    }

    private static Coverage calcCoverage(FArray array, RuleSet ruleSet, SelectorList selectorList, float decVal) {
        int covered = 0;
        int posCovered = 0;
        int pos = 0;
        int negCovered = 0;
        int neg = 0;
        int eventsNumber = array.rowsNumber();
        int decisionId = array.getDecAttrIdx();
        int i = 0;
        while (i < eventsNumber) {
            boolean bl;
            float dec;
            block10: {
                dec = array.readValue(decisionId, i);
                if (dec == decVal) {
                    ++pos;
                } else {
                    ++neg;
                }
                int n = i;
                FArray fArray = array;
                SelectorList selectorList2 = selectorList;
                RuleSet ruleSet2 = ruleSet;
                int n2 = 0;
                while (n2 < ruleSet2.complexSetArray.length) {
                    if (ruleSet2.complexSetArray[n2] != null) {
                        int n3 = ruleSet2.complexSetArray[n2].size();
                        int n4 = 0;
                        while (n4 < n3) {
                            if (ruleSet2.complexSetArray[n2].getComplex(n4).covers(selectorList2, fArray, n)) {
                                bl = true;
                                break block10;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                bl = false;
            }
            if (bl) {
                ++covered;
                if (dec == decVal) {
                    ++posCovered;
                } else {
                    ++negCovered;
                }
            }
            ++i;
        }
        Coverage coverage = new Coverage();
        new Coverage().coverage = (float)covered / (float)eventsNumber;
        coverage.posCoverage = (float)posCovered / (float)pos;
        coverage.negCoverage = (float)negCovered / (float)neg;
        return coverage;
    }

    public final int ruleSets() {
        return this.ruleSetArray.length;
    }

    /*
     * WARNING - void declaration
     */
    public final RuleSet getRuleSet(int index) {
        if (index >= 0 && index < this.ruleSetArray.length) {
            void var1_1;
            return this.ruleSetArray[var1_1];
        }
        return null;
    }

    private void init() {
        int i = 0;
        while (i < this.ruleSetArray.length) {
            this.ruleSetArray[i].verbose = this.verbose;
            this.selectorListArray[i].verbose = this.verbose;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        int decisionValIndex = 0;
        while (decisionValIndex < this.trainArray.getDecValues().length) {
            tmp.append(this.ruleSetArray[decisionValIndex].toString(this.selectorListArray[decisionValIndex], this.trainArray));
            ++decisionValIndex;
        }
        return var1_1.toString();
    }
}

