/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.supportVector;

import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.RevisionUtils;

public class MIRBFKernel
extends RBFKernel
implements MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = -8711882393708956962L;
    protected double[][] m_kernelPrecalc;

    public MIRBFKernel() {
    }

    public MIRBFKernel(Instances data, int cacheSize, double gamma) throws Exception {
        super(data, cacheSize, gamma);
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        double result = 0.0;
        Instances insts1 = id1 == -1 ? new Instances(inst1.relationalValue(1)) : new Instances(this.m_data.instance(id1).relationalValue(1));
        Instances insts2 = new Instances(this.m_data.instance(id2).relationalValue(1));
        double precalc1 = 0.0;
        int i = 0;
        while (i < insts1.numInstances()) {
            int j = 0;
            while (j < insts2.numInstances()) {
                precalc1 = id1 == -1 ? this.dotProd(insts1.instance(i), insts1.instance(i)) : this.m_kernelPrecalc[id1][i];
                double res = Math.exp(this.m_gamma * (2.0 * this.dotProd(insts1.instance(i), insts2.instance(j)) - precalc1 - this.m_kernelPrecalc[id2][j]));
                result += res;
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        this.m_kernelPrecalc = new double[data.numInstances()][];
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.disable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(data);
        }
        this.initVars(data);
        int i = 0;
        while (i < data.numInstances()) {
            Instances insts = new Instances(data.instance(i).relationalValue(1));
            this.m_kernelPrecalc[i] = new double[insts.numInstances()];
            int j = 0;
            while (j < insts.numInstances()) {
                this.m_kernelPrecalc[i][j] = this.dotProd(insts.instance(j), insts.instance(j));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9144 $");
    }
}

