% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMDCEVData.R
\name{GenerateMDCEVData}
\alias{GenerateMDCEVData}
\title{GenerateMDCEVData}
\usage{
GenerateMDCEVData(
  model,
  nobs = 1000,
  nalts = 10,
  inc_lo = 1e+05,
  inc_hi = 150000,
  price_lo = 100,
  price_hi = 500,
  alpha_parms = 0.5,
  scale_parms = 1,
  gamma_parms = stats::runif(nalts, 1, 2),
  psi_i_parms = c(-1.5, 3, -2, 1, 2),
  psi_j_parms = c(-5, 0.5, 2),
  nerrs = 1,
  tol = 1e-20,
  max_loop = 999
)
}
\arguments{
\item{model}{A string indicating which model specification is estimated.
The options are "alpha", "gamma", "hybrid" and "hybrid0".}

\item{nobs}{Number of individuals}

\item{nalts}{Number of non-numeraire alts}

\item{inc_lo}{Low bound of income for uniform draw}

\item{inc_hi}{High bound of income for uniform draw}

\item{price_lo}{Low bound of price for uniform draw}

\item{price_hi}{High bound of price for uniform draw}

\item{alpha_parms}{Parameter value for alpha term}

\item{scale_parms}{Parameter value for scale term}

\item{gamma_parms}{Parameter value for gamma terms}

\item{psi_i_parms}{Parameter value for psi terms that vary by individual}

\item{psi_j_parms}{Parameter value for psi terms that vary by alt}

\item{nerrs}{Number of error draws for demand simulation}

\item{tol}{Tolerance level for simulations if using general approach}

\item{max_loop}{maximum number of loops for simulations if using general approach}
}
\value{
A `mdcev.data` object, which is a `data.frame` in long
    format. Also includes parms_true with parameter values
}
\description{
Simulate data for MDCEV model
}
\examples{
\donttest{
data <- GenerateMDCEVData(model = "hybrid0")
}
}
