% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcev.R, R/mdcev.methods.R
\name{mdcev}
\alias{mdcev}
\alias{print.mdcev}
\alias{summary.mdcev}
\alias{print.summary.mdcev}
\title{mdcev}
\usage{
mdcev(
  formula = NULL,
  data,
  weights = NULL,
  model = c("alpha", "gamma", "hybrid", "hybrid0"),
  n_classes = 1,
  fixed_scale1 = 0,
  trunc_data = 0,
  seed = "123",
  max_iterations = 2000,
  initial.parameters = NULL,
  algorithm = c("MLE", "Bayes"),
  flat_priors = NULL,
  print_iterations = TRUE,
  hessian = TRUE,
  prior_psi_sd = 10,
  prior_gamma_sd = 10,
  prior_alpha_sd = 0.5,
  prior_scale_sd = 1,
  prior_delta_sd = 10,
  gamma_fixed = 0,
  alpha_fixed = 0,
  std_errors = "mvn",
  n_draws = 50,
  keep_loglik = 0,
  random_parameters = "fixed",
  show_stan_warnings = TRUE,
  n_iterations = 200,
  n_chains = 4,
  n_cores = 4,
  max_tree_depth = 10,
  adapt_delta = 0.8,
  lkj_shape_prior = 4,
  ...
)

\method{print}{mdcev}(
  x,
  digits = max(3, getOption("digits") - 3),
  width = getOption("width"),
  ...
)

\method{summary}{mdcev}(object, printCI = FALSE, ...)

\method{print}{summary.mdcev}(x, ...)
}
\arguments{
\item{formula}{Formula for the model to be estimated.The formula is divided in
two parts, separated by the symbol \code{|}. The first part is reserved for
variables in the psi parameter. These can include alternative-specific and
individual-specific variables. The second part corresponds for individual-specific
variables that enter in the probability assignment in models with latent classes.}

\item{data}{The (IxJ) data to be passed to Stan of class \code{\link[rmdcev]{mdcev.data}}
including 1) id, 2) alt, 3) quant, 4) price, 5) income, and columns for psi variables.
Arrange data by id then alt. Note: I is number of individuals and J is number of
non-numeraire alternatives.}

\item{weights}{an optional vector of weights. Default to 1.}

\item{model}{A string indicating which model specification is estimated.
The options are "alpha", "gamma", "hybrid" and "hybrid0".}

\item{n_classes}{The number of latent classes.}

\item{fixed_scale1}{Whether to fix scale at 1.}

\item{trunc_data}{Whether the estimation should be adjusted for truncation}

\item{seed}{Random seed.}

\item{max_iterations}{Maximum number of iterations in MLE estimation.}

\item{initial.parameters}{Specify initial parameters intead of starting at random.
Initial parameter values should be included in a named list. For the "hybrid" specification,
initial parameters can be specified as:
init = list(psi = array(0, dim = c(1, num_psi)),
            gamma = array(1, dim = c(1, num_alt)),
            alpha = array(0.5, dim = c(1, 0)),
            scale = array(1, dim = c(1)))
where num_psi is number of psi parameters and num_alt is number of non-numeraire alternatives}

\item{algorithm}{Either "Bayes" for Bayes or "MLE"
for maximum liklihood estimation.}

\item{flat_priors}{indicator if completely uninformative priors should be specified. If using MLE, the
optimizing function will then be equal to log-likelihood. Defaults to 1 if MLE used and 0 if Bayes used.}

\item{print_iterations}{Whether to print iteration information}

\item{hessian}{Wheter to keep the Hessian matrix}

\item{prior_psi_sd}{standard deviation for normal prior with mean 0.}

\item{prior_gamma_sd}{standard deviation for normal prior with mean 0.}

\item{prior_alpha_sd}{standard deviation for normal prior with mean 0.5.}

\item{prior_scale_sd}{standard deviation for normal prior with mean 1.}

\item{prior_delta_sd}{standard deviation for normal prior with mean 0.}

\item{gamma_fixed}{indicator if gamma parameters should be fixed (i.e. not random).}

\item{alpha_fixed}{indicator if alpha parameters should be fixed (i.e. not random).}

\item{std_errors}{Compute standard errors using the delta method ("deltamethod")
or multivariate normal draws ("mvn"). The default is "mvn" as only mvn parameter draws are required
for demand and welfare simulation.}

\item{n_draws}{The number of multivariate normal draws for standard error calculations.}

\item{keep_loglik}{Whether to keep the log_lik calculations}

\item{random_parameters}{The form of the covariance matrix for
Bayes. Can be 'fixed', 'uncorr, 'corr'.}

\item{show_stan_warnings}{Whether to show warnings from Stan.}

\item{n_iterations}{The number of iterations in Bayesian estimation.}

\item{n_chains}{The number of chains in Bayesian estimation.}

\item{n_cores}{The number of cores to use in Bayesian estimation.
Can set using options(mc.cores = parallel::detectCores()).}

\item{max_tree_depth}{http://mc-stan.org/misc/warnings.html#maximum-treedepth-exceeded}

\item{adapt_delta}{http://mc-stan.org/misc/warnings.html#divergent-transitions-after-warmup}

\item{lkj_shape_prior}{Prior for Cholesky matrix}

\item{...}{Additional parameters to pass on to \code{rstan::stan}
and \code{rstan::sampling}.}

\item{x, object}{an object of class `mdcev`}

\item{digits}{the number of digits,}

\item{width}{the width of the printing,}

\item{printCI}{set to TRUE to print 95\% confidence intervals}
}
\value{
A object of class mdcev
}
\description{
Fit a MDCEV model using MLE or Bayes
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")

data_rec <- mdcev.data(data_rec, subset = id < 500,
                alt.var = "alt", choice = "quant")

mdcev_est <- mdcev( ~ 1,
data = data_rec,
model = "hybrid0",
algorithm = "MLE")
}
}
