% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_method.R
\name{plot.metalog}
\alias{plot.metalog}
\title{Plot of the metalog object}
\usage{
\method{plot}{metalog}(x, ...)
}
\arguments{
\item{x}{metalog object created using \code{metalog()}}

\item{...}{ignored; included for S3 generic/method consistency}
}
\value{
A summary plot of the CDF and PDF for each term
}
\description{
Plot of the metalog object
}
\examples{
# Load example data
\dontrun{
data("fishSize")

# Create a bounded metalog object

myMetalog <- metalog(fishSize$FishSize,
                     bounds=c(0, 60),
                     boundedness = 'b',
                     term_limit = 13)

plot(myMetalog)
}
}
