% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_lnc_threshold.R
\name{estimate_mse}
\alias{estimate_mse}
\title{Estimate MSE of LNC Estimator}
\usage{
estimate_mse(k = 5, alpha = 0, d = 2, rho = 0, N = 1000,
  M = 100, cluster = NULL)
}
\arguments{
\item{k}{Neighborhood order.}

\item{alpha}{Non-uniformity threshold (see details).}

\item{d}{Dimension.}

\item{rho}{Reference correlation (see details).}

\item{N}{Sample size.}

\item{M}{Number of replications.}

\item{cluster}{A \code{parallel} cluster object.}
}
\description{
Computes the MSE of the Local Non-Uniformity Correct (LNC) KSG estimator for a given value of the tuning parameter \code{alpha}, dimension, neighborhood order, and sample size.
}
\details{
The parameter \code{alpha} controls the threshold for the application of the non-uniformity correction to a particular point's neighborhood. Roughly, \code{alpha} is the ratio of the PCA aligned neighborhood volume to the rectangular aligned neighborhood volume below which indicates non-uniformity and the correction is applied.

If \code{alpha < 0} then a log scale is assumed; otherwise [0,1] scale is used. \code{alpha > 1} are unacceptable values. A value of \code{alpha = 0} forces no correction and LNC reverts to the KSG estimator.

The reference distribution that is assumed is a mean-zero multivariate normal distribution with a compound-symmetric covariance. The covariance matrix has a single correlation parameter supplied by \code{rho}.
}
\examples{
estimate_mse(N = 100,M = 2)
}
