% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_nearest_neighbor.R
\name{lnn_entropy}
\alias{lnn_entropy}
\title{Local Nearest Neighbor (LNN) Entropy Estimator}
\usage{
lnn_entropy(data, k = 5, tr = 30, bw = NULL)
}
\arguments{
\item{data}{Matrix of sample observations, each row is an observation.}

\item{k}{Order of the local kNN bandwidth selection.}

\item{tr}{Order of truncation (number of neighbors to include in entropy).}

\item{bw}{Bandwidth (optional) manually fix bandwidth instead of using local kNN bandwidth selection.}
}
\description{
Local Nearest Neighbor entropy estimator using Gaussian kernel and kNN selected bandwidth. Entropy is estimated by taking a Monte Carlo estimate using local kernel density estimate of the negative-log density.
}
\section{References}{


Loader, C. (1999). Local regression and likelihood. Springer Science & Business Media.

Gao, W., Oh, S., & Viswanath, P. (2017). Density functional estimators with k-nearest neighbor bandwidths. IEEE International Symposium on Information Theory - Proceedings, 1, 1351–1355.
}

\examples{
set.seed(123)
x <- rnorm(1000)
print(lnn_entropy(x))
#analytic entropy
print(0.5*log(2*pi*exp(1)))

}
