#' Virtual Class 'nsga3 - Simple Class for subassigment Values'
#'
#' The class 'nsga3' is a simple class union ([setClassUnion()])
#' of 'numeric', 'logical' and 'matrix'.
#'
#' @section Objects from the Class:
#' Since it is a virtual Class, no objects may be created from it.
#'
#' @slot call an object of class 'call' representing the matched call.
#' @slot type a character string specifying the type of genetic algorithm used.
#' @slot lower a vector providing for each decision variable the lower bounds of
#' the search space in case of real-valued or permutation encoded optimisations.
#' Formerly this slot was named min.
#' @slot upper a vector providing for each decision variable the upper bounds of
#' the search space in case of real-valued or permutation encoded optimizations.
#' Formerly this slot was named max.
#' @slot nBits a value specifying the number of bits to be used in binary
#' encoded optimizations.
#' @slot names a vector of character strings providing the names of decision
#' variables (optional).
#' @slot popSize the population size.
#' @slot front Range in which the individual is in the front generated by the
#' function ([non_dominated_fronts()])
#' @slot f Fronts generated by the function ([non_dominated_fronts()])
#' @slot iter the actual (or final) iteration of NSGA search.
#' @slot run the number of consecutive generations without any improvement in
#' the best fitness value before the NSGA is stopped.
#' @slot maxiter the maximum number of iterations to run before the NSGA search
#' is halted.
#' @slot suggestions a matrix of user provided solutions and included in the
#' initial population.
#' @slot population the current (or final) population.
#' @slot ideal_point Nadir point estimate used as lower bound in normalization.
#' @slot worst_point Worst point generated over generations.
#' @slot smin Index used to obtain the extreme points.
#' @slot extreme_points are selected using the ASF in the ([PerformScalarizing()]).
#' Necessary in the  nadir point generation.
#' @slot worst_of_population The worst individuals generated by objectives in
#' the current generation.
#' @slot worst_of_front The worst individuals in the first front generated by
#' objectives in the current generation.
#' @slot nadir_point Nadir point estimate used as upper bound in normalization.
#' @slot pcrossover the crossover probability.
#' @slot pmutation the mutation probability.
#' @slot reference_points NSGA-III uses a predefined set of reference points to
#' ensure diversity in obtained solutions.
#' The chosen refenrece points can be predefined in structured manner or
#' supplied by the user. We use the Das and Dennis procedure.
#' @slot fitness the values of fitness function for the current (or final)
#' population
#' @slot summary a matrix of summary statistics for fitness values at each
#' iteration (along the rows).
#' @slot fitnessValue the best fitness value at the final iteration.
#' @slot solution the value(s) of the decision variables giving the best
#' fitness at the final iteration.
#'
#' @examples
#' showClass('nsga3')
#' @export
setClass(Class = "nsga3",
  representation(call = "language",
    type = "character",
    lower = "numberOrNAOrMatrix",
    upper = "numberOrNAOrMatrix",
    nBits = "numberOrNAOrMatrix",
    names = "character",
    popSize = "numeric",
    front = "numberOrNAOrMatrix",
    f = "list",
    iter = "numeric",
    run = "numeric",
    maxiter = "numeric",
    suggestions = "matrix",
    population = "numberOrNAOrMatrix",
    ideal_point = "numberOrNAOrMatrix",
    worst_point = "numberOrNAOrMatrix",
    smin = "numberOrNAOrMatrix",
    extreme_points = "numberOrNAOrMatrix",
    worst_of_population = "numberOrNAOrMatrix",
    worst_of_front = "numberOrNAOrMatrix",
    nadir_point = "numberOrNAOrMatrix",
    pcrossover = "numberOrNAOrMatrix",
    pmutation = "numberOrNAOrMatrix",
    reference_points = "numberOrNAOrMatrix",
    fitness = "numberOrNAOrMatrix",
    summary = "list",
    fitnessValue = "numberOrNAOrMatrix",
    solution = "matrix")
  )
