% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsga2-class.R
\docType{class}
\name{nsga2-class}
\alias{nsga2-class}
\title{Virtual Class 'nsga2 - Simple Class for subassigment Values'}
\description{
The class 'nsga2' is a simple class union (\code{\link[=setClassUnion]{setClassUnion()}})
of 'numeric', 'logical' and 'matrix'.
}
\section{Slots}{

\describe{
\item{\code{call}}{an object of class 'call' representing the matched call.}

\item{\code{type}}{a character string specifying the type of genetic algorithm used.}

\item{\code{lower}}{a vector providing for each decision variable the lower bounds of
the search space in case of real-valued or permutation encoded optimisations.
Formerly this slot was named min.}

\item{\code{upper}}{a vector providing for each decision variable the upper bounds of
the search space in case of real-valued or permutation encoded optimizations.
Formerly this slot was named max.}

\item{\code{nBits}}{a value specifying the number of bits to be used in binary
encoded optimizations.}

\item{\code{names}}{a vector of character strings providing the names of decision
variables (optional).}

\item{\code{popSize}}{the population size.}

\item{\code{front}}{Rank of individuals on the non-dominated front.}

\item{\code{f}}{Front of individuals on the non-dominated front.}

\item{\code{iter}}{the actual (or final) iteration of NSGA search.}

\item{\code{run}}{the number of consecutive generations without any improvement in
the best fitness value before the NSGA is stopped.}

\item{\code{maxiter}}{the maximum number of iterations to run before the NSGA search
is halted.}

\item{\code{suggestions}}{a matrix of user provided solutions and included in the
initial population.}

\item{\code{population}}{the current (or final) population.}

\item{\code{pcrossover}}{the crossover probability.}

\item{\code{pmutation}}{the mutation probability.}

\item{\code{crowdingDistance}}{Crowding-comparison approach to estiate of the
perimeter of the cuboid formed by using the nearest neighbors as the vertices.}

\item{\code{fitness}}{the values of fitness function for the current (or final)
population}

\item{\code{summary}}{a matrix of summary statistics for fitness values at each
iteration (along the rows).}

\item{\code{fitnessValue}}{the best fitness value at the final iteration.}

\item{\code{solution}}{the value(s) of the decision variables giving the best fitness
at the final iteration.}
}}

\section{Objects from the Class}{

Since it is a virtual Class, no objects may be created from it.
}

\examples{
showClass('nsga2')
}
