% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_tables.R
\name{get_exchangerate_tables_from_interval}
\alias{get_exchangerate_tables_from_interval}
\title{Retrieves the exchange rate tables from a specific interval.}
\usage{
get_exchangerate_tables_from_interval(table, from, to)
}
\arguments{
\item{table}{specifies which table should be fetched.}

\item{from}{start day of the interval.}

\item{to}{end day of the interval.}
}
\value{
nbp_api_response object containing the exchange rates
tables from the specified interval.
}
\description{
Retrieves the exchange rate tables from a specific interval.
}
\details{
As exchange rate tables are not published on the weekends
fetching values from an interval containing a weekend will
result in a response that omits those days.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch the exchange rate table from the past week
      response <- get_exchangerate_tables_from_interval("A", Sys.Date() - 7, Sys.Date())
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other tables: 
\code{\link{get_current_exchangerate_table}()},
\code{\link{get_exchangerate_table_from}()},
\code{\link{get_last_n_exchangerate_tables}()},
\code{\link{get_todays_exchangerate_table}()}
}
\concept{tables}
