% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metareg.plot_function.R
\name{metareg_plot}
\alias{metareg_plot}
\title{End-user-ready results for network meta-regression}
\usage{
metareg_plot(full, reg, compar, cov_value, drug_names, save_xls)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{reg}{An object of S3 class \code{\link{run_metareg}}. See 'Value' in
\code{\link{run_metareg}}.}

\item{compar}{A character to indicate the comparator intervention. It must be
any name found in \code{drug_names}.}

\item{cov_value}{A list of two elements in the following order: a number
for the covariate value of interest (see 'Arguments' in
\code{\link{run_metareg}}), and a character to indicate the name of
the covariate. See also 'Details'.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl]{write_xlsx}}
function) to the working directory of the user. The default is \code{FALSE}
(do not export).}
}
\value{
\code{metareg_plot} prints on the R console a message on the most
  parsimonious model (if any) based on the deviance information criterion
  (DIC; in red text). Furthermore, the function returns the following list of
   elements:
  \tabular{ll}{
   \code{table_estimates} \tab The posterior mean, and 95\% credible interval
   of the summary effect measure (according to the argument \code{measure}
   defined in \code{\link{run_model}}) for each comparison with the selected
   intervention under network meta-analysis and network meta-regression
   based on the specified \code{cov_value}.\cr
   \tab \cr
   \code{table_predictions} \tab The posterior mean, and 95\% predictive
   interval of the summary effect measure (according to the argument
   \code{measure} defined in \code{\link{run_model}}) for each comparison
   with the selected intervention under network meta-analysis and network
   meta-regression based on the specified \code{cov_value}.\cr
   \tab \cr
   \code{table_model_assessment} \tab The DIC, total residual deviance,
   number of effective parameters, and the posterior median and 95\% credible
   interval of between-trial standard deviation (\emph{tau}) under each model
   (Spiegelhalter et al., (2002)). When a fixed-effect model has been
   performed, \code{metareg_plot} does not return results on tau.\cr
   \tab \cr
   \code{table_regression_coeffients} \tab The posterior mean and 95\%
   credible interval of the regression coefficient(s).\cr
   \tab \cr
   \code{interval_plots} \tab The panel of forest-plots on the estimated and
   predicted effect sizes of comparisons with the selected intervention under
   network meta-analysis and network meta-regression based on the specified
   \code{cov_value}. See 'Details' and 'Value' in
   \code{\link{forestplot_metareg}}.\cr
   \tab \cr
   \code{sucra_scatterplot} \tab A scatterplot of the SUCRA values from the
   network meta-analysis against the SUCRA values from the network
   meta-regression based on the specified \code{cov_value}. See 'Details'
   and 'Value' in \code{\link{scatterplot_sucra}}.
}
}
\description{
Illustrates the effect estimates, predictions and regression
  coefficients of comparisons with a specific comparator and also exports
  these results to an Excel format.
}
\details{
The DIC of the network meta-analysis model is compared with the DIC
  of the network meta-regression model. If the difference in DIC exceeds 5,
  the network meta-regression model is preferred; if the difference in DIC is
  less than -5, the network meta-analysis model is preferred; otherwise,
  there is little to choose between the compared models.

  When the covariate is binary, specify in the second element of
  \code{cov_value} the name of the level for which the output will be
  created.

  Furthermore, \code{metareg_plot} exports all tabulated results to separate
  'xlsx' files (via the \code{\link[writexl]{write_xlsx}} function)
  to the working directory of the user.

  \code{metareg_plot} can be used only for a network of interventions. In the
  case of two interventions, the execution of the function will be stopped
  and an error message will be printed on the R console.
}
\examples{
data("nma.baker2009")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_baker.rds', package = 'rnmamod'))

# Read results from 'run_metareg' (exchangeable structure)
reg <- readRDS(system.file('extdata/reg_baker.rds', package = 'rnmamod'))

# Publication year as the covariate
pub_year <- c(1996, 1998, 1999, 2000, 2000, 2001, rep(2002, 5), 2003, 2003,
              rep(2005, 4), 2006, 2006, 2007, 2007)

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "budesonide", "budesonide plus formoterol",
                  "fluticasone", "fluticasone plus salmeterol",
                  "formoterol", "salmeterol", "tiotropium")

# Plot the results from both models for all comparisons with salmeterol and
# publication year 2000
metareg_plot(full = res,
             reg = reg,
             compar = "salmeterol",
             cov_value = list(2000, "publication year"),
             drug_names = interv_names)

}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}

Spiegelhalter DJ, Best NG, Carlin BP, van der Linde A. Bayesian measures of
model complexity and fit. \emph{J R Stat Soc B} 2002;\bold{64}:583--616.
\doi{10.1111/1467-9868.00353}
}
\seealso{
\code{\link{forestplot_metareg}}, \code{\link{run_metareg}},
  \code{\link{run_model}}, \code{\link{scatterplot_sucra}},
  \code{\link[writexl]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
