# from https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/NORMAL_HLY_documentation.pdf
ncdc_units_normal_hly <- list(
  "HLY-CLDH-NORMAL" = list(name = "HLY-CLDH-NORMAL", units = "", description = "Cooling degree hours"),
  "HLY-CLOD-PCTBKN" = list(name = "HLY-CLOD-PCTBKN", units = "percent_tenths", description = "Clouds broken percentage"),
  "HLY-CLOD-PCTCLR" = list(name = "HLY-CLOD-PCTCLR", units = "percent_tenths", description = "Clouds clear percentage"),
  "HLY-CLOD-PCTFEW" = list(name = "HLY-CLOD-PCTFEW", units = "percent_tenths", description = "Clouds few percentage"),
  "HLY-CLOD-PCTOVC" = list(name = "HLY-CLOD-PCTOVC", units = "percent_tenths", description = "Clouds overcast percentage"),
  "HLY-CLOD-PCTSCT" = list(name = "HLY-CLOD-PCTSCT", units = "percent_tenths", description = "Clouds scattered percentage"),
  "HLY-DEWP-10PCTL" = list(name = "HLY-DEWP-10PCTL", units = "fahrenheit_tenths", description = "Dew point 10th percentile"),
  "HLY-DEWP-90PCTL" = list(name = "HLY-DEWP-90PCTL", units = "fahrenheit_tenths", description = "Dew point 90th percentile"),
  "HLY-DEWP-NORMAL" = list(name = "HLY-DEWP-NORMAL", units = "fahrenheit_tenths", description = "Dew point mean"),
  "HLY-HIDX-NORMAL" = list(name = "HLY-HIDX-NORMAL", units = "fahrenheit_tenths", description = "Heat index mean"),
  "HLY-HTDH-NORMAL" = list(name = "HLY-HTDH-NORMAL", units = "", description = "Heating degree hours"),
  "HLY-PRES-10PCTL" = list(name = "HLY-PRES-10PCTL", units = "hectopascals", description = "Sea level pressure 10th percentile"),
  "HLY-PRES-90PCTL" = list(name = "HLY-PRES-90PCTL", units = "hectopascals", description = "Sea level pressure 90th percentile"),
  "HLY-PRES-NORMAL" = list(name = "HLY-PRES-NORMAL", units = "hectopascals", description = "Sea level pressure mean"),
  "HLY-TEMP-10PCTL" = list(name = "HLY-TEMP-10PCTL", units = "fahrenheit_tenths", description = "Temperature 10th percentile"),
  "HLY-TEMP-90PCTL" = list(name = "HLY-TEMP-90PCTL", units = "fahrenheit_tenths", description = "Temperature 90th percentile"),
  "HLY-TEMP-NORMAL" = list(name = "HLY-TEMP-NORMAL", units = "fahrenheit_tenths", description = "Temperature mean"),
  "HLY-WCHL-NORMAL" = list(name = "HLY-WCHL-NORMAL", units = "fahrenheit_tenths", description = "Wind chill mean"),
  "HLY-WIND-1STDIR" = list(name = "HLY-WIND-1STDIR", units = "no units; see values", description = "Prevailing wind direction (1-8)", values = "1=N, 2=NE, 3=E, 4=SE, 5=S, 6=SW, 7=W, 8=NW"),
  "HLY-WIND-1STPCT" = list(name = "HLY-WIND-1STPCT", units = "percent", description = "Prevailing wind percentage"),
  "HLY-WIND-2NDDIR" = list(name = "HLY-WIND-2NDDIR", units = "no units; see values", description = "Secondary wind direction (1-8)", values = "1=N, 2=NE, 3=E, 4=SE, 5=S, 6=SW, 7=W, 8=NW"),
  "HLY-WIND-2NDPCT" = list(name = "HLY-WIND-2NDPCT", units = "percent", description = "Secondary wind percentage"),
  "HLY-WIND-AVGSPD" = list(name = "HLY-WIND-AVGSPD", units = "meters_per_sec", description = "Average wind speed"),
  "HLY-WIND-PCTCLM" = list(name = "HLY-WIND-PCTCLM", units = "percent_tenths", description = "Percentage calm"),
  "HLY-WIND-VCTDIR" = list(name = "HLY-WIND-VCTDIR", units = "degrees", description = "Mean wind vector direction"),
  "HLY-WIND-VCTSP" = list(name = "HLY-WIND-VCTSP", units = "meters_per_sec", description = "Mean wind vector magnitude")
)
