% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_utils.r
\name{meteo_coverage}
\alias{meteo_coverage}
\title{Determine the "coverage" for a station data frame}
\usage{
meteo_coverage(
  meteo_df,
  obs_start_date = NULL,
  obs_end_date = NULL,
  verbose = FALSE
)
}
\arguments{
\item{meteo_df}{a \emph{meteo} \code{data.frame}}

\item{obs_start_date}{specify either or both (obs_start_date, obs_end_date)
to constrain coverate tests. These should be \code{Date} objects.}

\item{obs_end_date}{specify either or both (obs_start_date, obs_end_date)
to constrain coverate tests. These should be \code{Date} objects.}

\item{verbose}{if \code{TRUE} will display the coverage summary along
with returning the coverage data.frame}
}
\value{
a \code{list} containing 2 \code{data.frame}s named 'summary' and 'detail'.
The 'summary' \code{data.frame} contains columns: \preformatted{
$ id         (chr)
$ start_date (time)
$ end_date   (time)
$ total_obs  (int)
}
with additional fields (and their coverage percent) depending on which
weather variables were queried and available for the weather station. The
\code{data.frame} named 'detail' contains the same columns as the \code{meteo_df} input
data, but expands the rows to contain \code{NA}s for days without data.
}
\description{
Call this function after pulling down observations for a set of stations
to retrieve the "coverage" (i.e. how complete each field is). If either
or both \code{obs_start_date} or \code{obs_end_date} are specified,
the coverage test will be limited to that date range.
}
\details{
There is an \code{autoplot} method for the output of this function.
}
\examples{
\dontrun{

monitors <- c("ASN00095063", "ASN00024025", "ASN00040112", "ASN00041023",
             "ASN00009998", "ASN00066078", "ASN00003069", "ASN00090162",
             "ASN00040126", "ASN00058161")
obs <- meteo_pull_monitors(monitors)
obs_covr <- meteo_coverage(obs)

if (interactive()) {
  library("ggplot2")
  autoplot(obs_covr)
}
}
}
