% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fData.R
\name{fData}
\alias{fData}
\title{\code{S3} Class for univariate functional datasets.}
\usage{
fData(grid, values)
}
\arguments{
\item{grid}{the evenly spaced grid over which the functional observations are
measured. It must be a numeric vector of length \code{P}.}

\item{values}{the values of the observations in the functional dataset,
prodived in form of a 2D data structure (e.g. matrix or array) having as
rows the observations and as columns their measurements over the 1D grid of
length \code{P} specified in \code{grid}.}
}
\value{
The function returns a \code{S3} object of class \code{fData}, containing
the following elements:
\itemize{
 \item{"\code{N}"}{: the number of elements in the dataset;}
 \item{"\code{P}"}{: the number of points in the 1D grid over which elements
 are measured;}
 \item{"\code{t0}"}{: the starting point of the 1D grid;}
 \item{"\code{tP}"}{: the ending point of the 1D grid;}
 \item{"\code{values}"}{: the matrix of measurements of the functional
 observations on the 1D grid provided with \code{grid}.}
}
}
\description{
This function implements a constructor for elements of \code{S3} class
 \code{fData}, aimed at implementing a representation of a functional
 dataset.
}
\details{
The functional dataset is represented as a collection of measurement of the
 observations on an evenly spaced, 1D grid of discrete points (representing,
 e.g. time), namely, for functional data defined over a grid \eqn{[t_0,
 t_1, \ldots, t_{P-1}]}:

\deqn{ f_{i,j} = f_i( t_0 + j h ), \quad h =  \frac{t_P - t_0}{N},
 \quad \forall j = 1, \ldots, P, \quad \forall i = 1, \ldots
 N.}
}
\examples{
# Defining parameters
N = 20
P = 1e2

# One dimensional grid
grid = seq( 0, 1, length.out = P )

# Generating an exponential covariance function (see related help for more
# information )
C = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )

# Generating a synthetic dataset with a gaussian distribution and
# required mean and covariance function:
values = generate_gauss_fdata( N,
                               centerline = sin( 2 * pi * grid ),
                               Cov = C )

fD = fData( grid, values )
}
\seealso{
\code{\link{generate_gauss_fdata}}, \code{\link{sub-.fData}}
}

