% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indTab.R
\name{indTab}
\alias{indTab}
\title{Independence table}
\usage{
indTab(x, margin = c("gmean_sum", "sum"), frequency = c("relative",
  "absolute"), pTabMethod = c("dirichlet", "half", "classical"))
}
\arguments{
\item{x}{an object of class table}

\item{margin}{determines how the margins of the table should be estimated (default via geometric mean margins)}

\item{frequency}{indicates whether absolute or relative frequencies should be computed.}

\item{pTabMethod}{to estimate the propability table. Default is \sQuote{dirichlet}. Other available methods: 
\sQuote{classical} that is function \code{prop.table()} from package base or method \dQuote{half} that add 1/2 to each cell
to avoid zero problems.}
}
\value{
The independence table(s) with either relative or absolute frequencies.
}
\description{
Estimates the expected frequencies from an m-way table under the 
null hypotheses of independence.
}
\details{
Because of the compositional nature of probability tables, the independence tables should 
be estimated using geometric marginals.
}
\examples{
data(precipitation) 
tab1 <- indTab(precipitation)
tab1
sum(tab1)

\dontrun{
data("PreSex", package = "vcd")
indTab(PreSex)
}
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Templ, M., Hron, K. (2015)
Independence in contingency tables using simplicial geometry. 
\emph{Communications in Statistics - Theory and Methods}, 44 (18), 3978--3996.
}
\author{
Matthias Templ
}
