% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int2x2.R
\name{int2x2}
\alias{int2x2}
\title{Interaction 2x2 table}
\usage{
int2x2(x, margin = 3, pTabMethod = c("dirichlet", "half", "classical"))
}
\arguments{
\item{x}{a 2x2 table}

\item{margin}{if multidimensional table (larger than 2-dimensional), 
then the margin determines on which dimension the independene tables should be estimated.}

\item{pTabMethod}{to estimate the propability table. Default is \sQuote{dirichlet}. Other available methods: 
\sQuote{classical} that is function \code{prop.table()} from package base or method \dQuote{half} that add 1/2 to each cell
to avoid zero problems.}
}
\value{
The independence table(s) with either relative or absolute frequencies.
}
\description{
Estimates the interactions from an 2x2 table under the 
null hypotheses of independence.
}
\examples{
data(employment) 
int2x2(employment)
}
\references{
Facevicova, K., Hron, K., Todorov, V., Guo, D., Templ, M. (2014).
Logratio approach to statistical analysis of 2x2 compositional tables.
\emph{Journal of Applied Statistics}, 41 (5), 944--958.
}
\author{
Kamila Facevicova, Matthias Templ
}
