% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\title{Classical estimates for tables}
\usage{
stats(
  x,
  margins = NULL,
  statistics = c("phi", "cramer", "chisq", "yates"),
  maggr = mean
)
}
\arguments{
\item{x}{a data.frame, matrix or table}

\item{margins}{margins}

\item{statistics}{statistics of interest}

\item{maggr}{a function for calculating the mean margins of a table, default is the arithmetic mean}
}
\value{
List containing all statistics
}
\description{
Some standard/classical (non-compositional) statistics
}
\details{
statistics \sQuote{phi} is the values of the table divided by the product of margins. \sQuote{cramer} normalize these values according to the dimension of the table. \sQuote{chisq} are the expected values according to Pearson while \sQuote{yates} according to Yates.

For the \code{maggr} function argument, arithmetic means (\code{mean}) should be chosen to obtain the classical results. Any other user-provided functions should be take with care since the classical estimations relies on the arithmetic mean.
}
\examples{
data(precipitation) 
tab1 <- indTab(precipitation)
stats(precipitation)
stats(precipitation, statistics = "cramer")
stats(precipitation, statistics = "chisq")
stats(precipitation, statistics = "yates")

## take with care 
## (the provided statistics are not designed for that case):
stats(precipitation, statistics = "chisq", maggr = gmean)
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Templ, M., Hron, K. (2015)
Independence in contingency tables using simplicial geometry. 
\emph{Communications in Statistics - Theory and Methods}, 44 (18), 3978--3996.
}
\author{
Matthias Templ
}
