% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transformations.R
\name{fcenLRinv}
\alias{fcenLRinv}
\title{Inverse of fcenLR transformations (functional)}
\usage{
fcenLRinv(z, z_step, fcenLR, k = 1)
}
\arguments{
\item{z}{grid of points defining the abscissa}

\item{z_step}{step of the grid of the abscissa}

\item{fcenLR}{grid evaluation of (i) fcenLR[lambda] transformed lambda-density,
(ii) fcenLR[u] transformed P-density, (iii) fcenLR[P] transformed P-density}

\item{k}{value of the integral of density; if k=1 it returns a unit-integral representation of density}
}
\value{
\code{out} ... grid evaluation of (i) lambda-density in B2(lambda), 
(ii) P-density in unweighted B2(lambda), (iii) P-density in B2(P)
}
\description{
Inverse of fcenLR transformations
}
\details{
By default, it returns a unit-integral representation of density.
}
\examples{
# Example (normal density)
t = seq(-4.7,4.7, length = 1000)
t_step = diff(t[1:2])

mean = 0; sd = 1.5
f = dnorm(t, mean, sd)
f1 = f/trapzc(t_step,f)

f.fcenLR = fcenLR(t,t_step,f) 
f.fcenLRinv = fcenLRinv(t.fine,t_step,f.fcenLR)

plot(t,f.fcenLR, type="l",las=1, ylab="fcenLR(density)", 
  cex.lab=1.2,cex.axis=1.2, col="darkblue",lwd=2)
abline(h=0, col="red")

plot(t,f.fcenLRinv, type="l",las=1, 
  ylab="density",cex.lab=1.2,cex.axis=1.2, col="darkblue",lwd=2,lty=1)
lines(t,f1,lty=2,lwd=2,col="gold")  
}
\author{
R. Talska\email{talskarenata@seznam.cz}, A. Menafoglio, K. Hron\email{karel.hron@upol.cz}, J. J. Egozcue, J. Palarea-Albaladejo
}
