% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{socExp}
\alias{socExp}
\title{social expenditures}
\format{
A data frame with 20 observations on the following 8 variables (country + currency + row-wise sorted cells of 2x3 compositional table).
}
\usage{
data(socExp)
}
\description{
Social expenditures according to source (public or private) 
and three important branches (health, old age, incapacity related) in 
selected OECD countries in 2010. Expenditures are always provided 
in the respective currency.
}
\details{
\itemize{
\item{\code{country }}{Country of origin}
\item{\code{currency }}{Currency unit (in Million)}
\item{\code{health-public }}{Health from the public}
\item{\code{old-public }}{Old age expenditures from the public}
\item{\code{incap-public }}{Incapacity related expenditures from the public}
\item{\code{health-private }}{Health from private sources}
\item{\code{old-private }}{Old age expenditures from private sources}
\item{\code{incap-private }}{Incapacity related expenditures from private sources}
}
}
\examples{

data(socExp)
str(socExp)
rowSums(socExp[, 3:ncol(socExp)])
}
\references{
OECD, \url{https://www.oecd.org}
}
\author{
conversion to R by Karel Hron Karel Hron and modifications by Matthias Templ \email{matthias.templ@tuwien.ac.at}
}
\keyword{data}
