% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robetsforecast.R
\name{forecast.robets}
\alias{forecast.robets}
\title{Forecasting using ROBETS models}
\usage{
\method{forecast}{robets}(object, h = ifelse(object$m > 1, 2 * object$m, 10),
  level = c(80, 95), PI = TRUE, lambda = object$lambda, ...)
}
\arguments{
\item{object}{An object of class "\code{robets}". Usually the result of a call to \code{\link{robets}}.}

\item{h}{Number of periods for forecasting}

\item{level}{Confidence level for prediction intervals.}

\item{PI}{If \code{TRUE}, prediction intervals are calculated.}

\item{lambda}{Box-Cox transformation parameter. Ignored if NULL. Otherwise, forecasts back-transformed via an inverse Box-Cox transformation.}

\item{...}{Other arguments.}
}
\value{
An object of class "\code{forecast}". The function \code{summary} is used to obtain and print a summary of the results, while the function \code{plot} produces a plot of the forecasts. The generic accessor functions \code{fitted.values} and \code{residuals} extract useful features of the value returned by \code{forecast.robets}. An object of class \code{"forecast"} is a list containing at least the following elements:
\itemize{
\item{model: }{A list containing information about the fitted model}
\item{method: }{The name of the forecasting method as a character string}
\item{mean: }{Point forecasts as a time series}
\item{x: }{The original time series (either \code{object} itself or the time series used to create the model stored as \code{object}).}
\item{residuals: }{Residuals from the fitted model. For models with additive errors, the residuals are x - fitted values. For models with multiplicative errors, the residuals are equal to x /(fitted values) - 1.}
\item{fitted: }{Fitted values (one-step ahead forecasts)}
}
}
\description{
Returns forecasts and other information for univariate ROBETS models.
}
\details{
The code of this function is based on the function \code{forecast.ets} of the package \code{forecast} of Hyndman and Khandakar (2008).
}
\examples{
library(forecast)
model <- robets(nottem)
plot(forecast(model))
}
\author{
Ruben Crevits, \email{ruben.crevits@kuleuven.be}
}
\references{
Crevits, R., and Croux, C (2016) "Robust Exponential Smoothing".\emph{Working paper}.

Hyndman, R. J., and Khandakar, Y (2008) "Automatic time series forecasting: The forecasting package for R".\emph{Journal of Statistical Software} \strong{27}(3).
}
\seealso{
\code{\link{robets}}
}

