% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{prepGraph}
\alias{prepGraph}
\title{prepGraph}
\usage{
prepGraph(file, file.format = c("edgelist", "pajek", "ncol", "lgl",
  "graphml", "dimacs", "graphdb", "gml", "dl", "igraph"),
  numbers = FALSE, directed = FALSE, header = FALSE)
}
\arguments{
\item{file}{The file to read from.}

\item{file.format}{Character constant giving the file format. Right now
as_edgelist, pajek, graphml, gml, ncol, lgl, dimacs, graphdb and igraph are
supported}

\item{numbers}{A logical value indicating if the names of the nodes are 
values.This argument is settable for the edgelist format. 
The default is FALSE.}

\item{directed}{A logical value indicating if is a directed graph. The 
default is FALSE.}

\item{header}{A logical value indicating whether the file contains 
the names of the variables as its first line.This argument is settable 
for the edgelist format.The default is FALSE.}
}
\value{
An igraph object, which do not contain loop and multiple edges.
}
\description{
The prepGraph function is able to read graphs from a file and 
to prepare them for the analysis.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
}
