% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robmed-deprecated.R
\name{robmed-deprecated}
\alias{robmed-deprecated}
\alias{fortify.boot_test_mediation}
\alias{fortify.sobel_test_mediation}
\alias{fortify.list}
\alias{plot_mediation}
\alias{plot_mediation.boot_test_mediation}
\alias{plot_mediation.sobel_test_mediation}
\alias{plot_mediation.list}
\alias{plot_mediation.default}
\title{Deprecated functions in package \pkg{robmed}}
\usage{
\method{fortify}{boot_test_mediation}(model, data, method = c("dot",
  "density"), parm = NULL, ...)

\method{fortify}{sobel_test_mediation}(model, data, method = c("dot",
  "density"), parm = NULL, level = 0.95, ...)

\method{fortify}{list}(model, data, ...)

plot_mediation(object, ...)

\method{plot_mediation}{boot_test_mediation}(object, method = c("dot",
  "density"), parm = NULL, ...)

\method{plot_mediation}{sobel_test_mediation}(object, data,
  method = c("dot", "density"), parm = c("Direct", "ab"),
  level = 0.95, ...)

\method{plot_mediation}{list}(object, data, method = c("dot", "density"),
  parm = NULL, level = 0.95, ...)

\method{plot_mediation}{default}(object, mapping = attr(object,
  "mapping"), facets = attr(object, "facets"), ...)
}
\arguments{
\item{model, object}{an object inheriting from class
\code{"\link{test_mediation}"} containing results from
(robust) mediation analysis, or a list of such objects.}

\item{data}{for the \code{"boot_test_mediation"} method, this is currently
ignored.  For the \code{"sobel_test_mediation"} method, this is an optional
numeric vector containing the \eqn{x}-values at which to evaluate the
assumed normal density from Sobel's test (only used in case of a density
plot).  The default is to take 100 equally spaced points between the
estimated indirect effect \eqn{\pm}{+/-} three times the standard error
according to Sobel's formula.}

\item{method}{a character string specifying for which plot to construct the
data frame.  Possible values are \code{"dot"} for a dot plot of selected
effects, or \code{"density"} for a density plot of the indirect effect(s).}

\item{parm}{a character string specifying the effects to be included
in a dot plot.  The default is to include the direct and the indirect
effect(s).}

\item{\dots}{additional arguments to be passed to and from methods.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test to be included in a dot plot.  The default is to include
95\% confidence intervals.}

\item{mapping}{an aesthetic mapping to override the default behavior
(see \code{\link[ggplot2]{aes}()} or \code{\link[ggplot2]{aes_}()}).}

\item{facets}{a faceting formula to override the default behavior
(only used in case of a dot plot).  If supplied,
\code{\link[ggplot2]{facet_wrap}()} or \code{\link[ggplot2]{facet_grid}()}
is called depending on whether the formula is one-sided or two-sided.}
}
\value{
\code{fortify()} returns a data frame containing the necessary data for the
selected plot, as well as additional information stored in attributes.

\code{plot_mediation()} returns an object of class
\code{"\link[ggplot2]{ggplot}"}.
}
\description{
These functions are provided for compatibility with older versions only, and
may be defunct as soon as the next release.
}
\details{
\code{fortify()} supplements the estimated coefficients with other useful
information for informative visualization of the (robust) mediation analysis
results.  It is thereby possible to construct data frames for dot plots of
selected effects, as well as density plots of the indirect effect.
From version 0.6.0 onwards, it is recommended to use
\code{\link{setup_ci_plot}()}, \code{\link{setup_density_plot}()}, or
\code{\link{setup_ellipse_plot}()} instead.

\code{plot_mediation()} produces a dot plot of selected effects in the
mediation model, or a density plot of the indirect effect.  From
version 0.6.0 onwards, it is recommended to use \code{\link{ci_plot}()},
\code{\link{density_plot}()}, or \code{\link{ellipse_plot}()} instead.
}
\examples{
\donttest{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create dot plot for robust bootstrap test
plot_mediation(robust_boot, method = "dot")
# equivalently
dot <- fortify(robust_boot, method = "dot")
plot_mediation(dot)

# create density plot for robust bootstrap test
plot_mediation(robust_boot, method = "density")
# equivalently
density <- fortify(robust_boot, method = "density")
plot_mediation(density)

# run standard bootstrap test
standard_boot <- test_mediation(BSG2014,
                                x = "ValueDiversity",
                                y = "TeamCommitment",
                                m = "TaskConflict",
                                robust = FALSE)

# compare robust and standard tests
tests <- list(Standard = standard_boot, Robust = robust_boot)
plot_mediation(tests, method = "dot")
plot_mediation(tests, method = "density")
}

}
\seealso{
\code{\link{test_mediation}()}, \code{\link{ci_plot}()},
\code{\link{density_plot}()}, \code{\link{ellipse_plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
