% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{huberwgt}
\alias{huberwgt}
\alias{weighted_mean_huber}
\alias{weighted_total_huber}
\alias{svymean_huber}
\alias{svytotal_huber}
\title{Huber M-estimators of the weighted mean and weighted total}
\usage{
weighted_mean_huber(x, w, k = 1.5, type = "rht", info = FALSE,
  na.rm = FALSE, ...)

weighted_total_huber(x, w, k = 1.5, type = "rht", info = FALSE,
  na.rm = FALSE, ...)

svymean_huber(x, design, k = 1.5, type = "rht", ...)

svytotal_huber(x, design, k = 1.5, ...)
}
\arguments{
\item{x}{a numeric vector (\code{weighted.[total/mean].huber} or
\code{weighted.[total/mean].huber}); a formula object or variable
name (\code{svymean_huber} or \code{svytotal_huber})}

\item{w}{a numeric vector of weights}

\item{k}{a robustness tuning constant, \eqn{k} in \eqn{[0, \infty)}}

\item{type}{type of estimator: \code{"rht"} (default) or \code{"rwm"}}

\item{info}{logical (default: \code{FALSE}); if \code{TRUE} further
estimation details are returned}

\item{na.rm}{a logical value indicating whether \code{NA} values should
be stripped before the computation proceeds.}

\item{...}{additional arguments passed to the control object
(see \code{\link{rht_control}})}

\item{design}{a \code{survey.design} object (see \link[survey]{svydesign}
in \pkg{survey})}
}
\value{
\itemize{
   \item An estimate (scalar) for \code{weighted.[total/mean].huber}
   (unless \code{info=TRUE})
   \item An object of class \code{svystat.rob} for functions of the type
   \code{msvy[total/mean]}, i.e. a list including the following components:
   \code{characteristic}, \code{estimator}, \code{estimate}, \code{variance},
   \code{robust}, \code{optim}, \code{residuals}, \code{model}, \code{design},
   and \code{call}.
}
}
\description{
Weighted Huber M-estimators of the mean and total are available in two forms:
\itemize{
   \item \strong{bare-bone} functions: \code{weighted_mean_huber} and
 \code{weighted_total_huber},
   \item estimation \strong{methods}: \code{svymean_huber} and
 \code{svytotal_huber} (incl. variance estimation
 based on the functionality of the \pkg{survey} package).
}
}
\details{
\describe{
   \item{\emph{Overview}}{
   Robust M-estimator of the Horvitz--Thompson total or the Hajek mean
 \itemize{
 \item bare-bone functions: return the estimate (no variance estimation)
 \item estimation methods on the basis of \pkg{survey} (incl. variance estimation)
 }
   }
   \item{\emph{Type}}{
   Two \code{type}s of estimation methods are available:
 \describe{
    \item{\code{rht}}{(robust) Horvitz-Thompson M-estimator of the
    total/mean
    }
    \item{\code{rwm}}{(robust) weighted mean estimator of
    a Hajek-type estimator of the mean.
    }
 }
   If the study variable \code{x} is positively correlated with the inclusion
   probabilities, type \code{"rht"} tends to be superior.
   }
   \item{\emph{Scale}}{
   M-estimators of location are not scale invariant. The unknown scale is
   estimated simultaneously with the estimate of location (mean or total) as
   the weighted median absolute deviation from the weighted median (MAD, see
   \code{\link{weighted_mad}}).

   }
   \item{\emph{Variance}}{
   Variance estimates of the mean or total estimator are computed as first-order
   linearization using the design-based-estimation capabilities available
   in package \pkg{survey}.
   }
   \item{\emph{Tuning}}{
   Additional arguments can be passed (via \dots) to specify the control
   parameters (e.g. number of iterations, psi-function, etc.); see
   \code{\link{rht_control}} for details.
   }
   \item{\emph{Domain estimation}}{
   Estimates for domains can be obtained using the \link[survey]{svyby}
   wrapper in the \pkg{survey} package (see examples).
   }
}
}
\note{
\code{huberwgt} is a generic name for the functions documented.
}
\section{Utility functions}{

For the methods \code{svymean_huber} and \code{svytotal_huber}, the following
utility functions can be used
\itemize{
   \item \code{summary} gives a summary of the estimation properties
   \item \code{\link{robweights}} retrieves the robustness weights
   \item \code{coef}, \code{vcov}, \code{residuals}, and \code{fitted}
 retrieve the estimate, variance, residuals and fitted
 values, respectively
}
}

\examples{
library(survey)
data(api)
dstrat <- svydesign(id=~1, strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
svymean_huber(~api00, dstrat, k = 2)
# Domain estimates
svyby(~api00, by = ~stype, design = dstrat, svymean_huber, k = 1.34)
}
\references{
Hulliger, B. (1995). Outlier Robust Horvitz-Thompson Estimators,
\emph{Survey Methodology} 21(1): 79-87.
}
\seealso{
\code{\link{svymean_trimmed}}, \code{\link{svytotal_trimmed}},
\code{\link{svymean_winsorized}}, \code{\link{svytotal_winsorized}},
\code{\link{weighted_mean_trimmed}}, \code{\link{weighted_total_trimmed}}
\code{\link{weighted_mean_winsorized}}, \code{\link{weighted_total_winsorized}}
}
