% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rao_index.R
\name{RaoProportions}
\alias{RaoProportions}
\title{Rao-Stirling diversity index based on proportions of cited disciplines.}
\usage{
RaoProportions(proportions, similarity)
}
\arguments{
\item{proportions}{A vector of proportions of citations to different disciplines of a single publication.
Since the elements of this vector are proportions, they need to be within the interval [0,1].}

\item{similarity}{A positive semi-definite matrix that encodes the similarity between disciplines, as explained in Porter and Rafols (2009).
The dimensions of this matrix are \emph{n} x \emph{n}, being \emph{n} the total number of disciplines.
The number of rows and the number columns of this matrix need to be equal to the length of \code{counts}.
The self-similarities (i.e. the diagonal elements) have to be 1.}
}
\value{
The Rao-Stirling diversity index of a publication.
}
\description{
This function calculates the Rao-Stirling diversity index of a single publication, based on its proportions of citations to different disciplines.
}
\references{
Porter, A. and Rafols, I. (2009) Is science becoming more interdisciplinary? Measuring and mapping six research fields over time. Scientometrics, Vol. 81, No. 3 (719-745). DOI:10.1007/s11192-008-2197-2
}
\keyword{internal}

