% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_df_to_source.R
\name{convert_df_to_source}
\alias{convert_df_to_source}
\alias{convert_csv_to_source}
\alias{convert_csv2_to_source}
\alias{convert_xlsx_to_source}
\alias{convert_sav_to_source}
\title{Convert 'rectangular' or spreadsheet-format data to one or more sources}
\usage{
convert_df_to_source(
  data,
  output = NULL,
  omit_empty_rows = TRUE,
  cols_to_utterances = NULL,
  cols_to_ciids = NULL,
  cols_to_codes = NULL,
  cols_to_attributes = NULL,
  oneFile = TRUE,
  cols_to_sourceFilename = cols_to_ciids,
  cols_in_sourceFilename_sep = "=",
  sourceFilename_prefix = "source_",
  sourceFilename_suffix = "",
  ciid_labels = NULL,
  ciid_separator = "=",
  attributesFile = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

convert_csv_to_source(
  file,
  importArgs = NULL,
  omit_empty_rows = TRUE,
  output = NULL,
  cols_to_utterances = NULL,
  cols_to_ciids = NULL,
  cols_to_codes = NULL,
  cols_to_attributes = NULL,
  oneFile = TRUE,
  cols_to_sourceFilename = cols_to_ciids,
  cols_in_sourceFilename_sep = "=",
  sourceFilename_prefix = "source_",
  sourceFilename_suffix = "",
  ciid_labels = NULL,
  ciid_separator = "=",
  attributesFile = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

convert_csv2_to_source(
  file,
  importArgs = NULL,
  omit_empty_rows = TRUE,
  output = NULL,
  cols_to_utterances = NULL,
  cols_to_ciids = NULL,
  cols_to_codes = NULL,
  cols_to_attributes = NULL,
  oneFile = TRUE,
  cols_to_sourceFilename = cols_to_ciids,
  cols_in_sourceFilename_sep = "=",
  sourceFilename_prefix = "source_",
  sourceFilename_suffix = "",
  ciid_labels = NULL,
  ciid_separator = "=",
  attributesFile = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

convert_xlsx_to_source(
  file,
  importArgs = list(overwrite = !preventOverwriting),
  omit_empty_rows = TRUE,
  output = NULL,
  cols_to_utterances = NULL,
  cols_to_ciids = NULL,
  cols_to_codes = NULL,
  cols_to_attributes = NULL,
  oneFile = TRUE,
  cols_to_sourceFilename = cols_to_ciids,
  cols_in_sourceFilename_sep = "=",
  sourceFilename_prefix = "source_",
  sourceFilename_suffix = "",
  ciid_labels = NULL,
  ciid_separator = "=",
  attributesFile = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)

convert_sav_to_source(
  file,
  importArgs = NULL,
  omit_empty_rows = TRUE,
  output = NULL,
  cols_to_utterances = NULL,
  cols_to_ciids = NULL,
  cols_to_codes = NULL,
  cols_to_attributes = NULL,
  oneFile = TRUE,
  cols_to_sourceFilename = cols_to_ciids,
  cols_in_sourceFilename_sep = "=",
  sourceFilename_prefix = "source_",
  sourceFilename_suffix = "",
  ciid_labels = NULL,
  ciid_separator = "=",
  attributesFile = NULL,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{data}{The data frame containing the data to convert.}

\item{output}{If \code{oneFile=TRUE} (the default), the name (and path)
of the file in which to save the processed source (if it is \code{NULL}, the
resulting character vector will be returned visibly instead of invisibly).
Note that the ROCK convention is to use \code{.rock} as extension.
If \code{oneFile=FALSE}, the path to which to write the
sources (if it is \code{NULL}, as a result a list of character vectors will be
returned visibly instead of invisibly).}

\item{omit_empty_rows}{Whether to omit rows where the values in the columns
specified to convert to utterances are all empty (or contain only
whitespace).}

\item{cols_to_utterances}{The names of the columns to convert to utterances,
as a character vectors.}

\item{cols_to_ciids}{The names of the columns to convert to class instance
identifiers (e.g. case identifiers), as a named character vector, with
the values being the column names in the data frame, and}

\item{cols_to_codes}{The names of the columns to convert to codes (i.e.
codes appended to every utterance), as a character vectors.}

\item{cols_to_attributes}{The names of the columns to convert to attributes,
as a named character vector, where each name is the name of the class
instance identifier to attach the attribute to. If only one column is passed
in \code{cols_to_ciids}, names can be omitted and a regular unnames character
vector can be passed.}

\item{oneFile}{Whether to store everything in one source, or create one
source for each row of the data (if this is set to \code{FALSE}, make sure that
\code{cols_to_sourceFilename} specifies one or more columns that together
uniquely identify each row; also, in that case, \code{output} must be an existing
directory on your PC).}

\item{cols_to_sourceFilename}{The columns to use as unique part of the
filesname of each source. These will be concatenated using
\code{cols_in_sourceFilename_sep} as a separator. Note that the final string
\emph{must} be unique for each row in the dataset, otherwise the filenames for
multiple rows will be the same and will be overwritten! By default, the
columns specified with class instance identifiers are used.}

\item{cols_in_sourceFilename_sep}{The separator to use when concatenating
the \code{cols_to_sourceFilename}.}

\item{sourceFilename_prefix, sourceFilename_suffix}{Strings that are
prepended and appended to the \code{col_to_sourceFilename} to create the full
filenames. Note that \code{.rock} will always be added to the end as extension.}

\item{ciid_labels}{The labels for the class instance identifiers. Class
instance identifiers have brief codes used in coding (e.g. 'cid' is the
default for Case Identifiers, often used to identify participants) as well
as more 'readable' labels that are used in the attributes (e.g. 'caseId' is
the default class instance identifier for Case Identifiers). These can be
specified here as a named vector, with each element being the label and
the element's name the identifier.}

\item{ciid_separator}{The separator for the class instance identifier - by
default, either an equals sign (\code{=}) or a colon (\code{:}) are supported, but
an equals sign is less ambiguous.}

\item{attributesFile}{Optionally, a file to write the attributes to if you
don't want them to be written to the source file(s).}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{encoding}{The encoding of the source(s).}

\item{silent}{Whether to suppress the warning about not editing the cleaned source.}

\item{file}{The path to a file containing the data to convert.}

\item{importArgs}{Optionally, a list with named elements representing
arguments to pass when importing the file.}
}
\value{
A source as a character vector.
}
\description{
These functions first import data from a 'data format', such as spreadsheets
in \code{.xlsx} format, comma-separated values files (\code{.csv}), or SPSS data
files (\code{.sav}). You can also just use R data frames (imported however you
want). These functions then use the columns you specified to convert these
data to one (\code{oneFile=TRUE}) or more (\code{oneFile=FALSE}) \code{rock}
source file(s), optionally including class instance
identifiers (such as case identifiers to identify participants, or location
identifiers, or moment identifiers, etc) and using those to link the
utterances to attributes from columns you specified. You can also precode
the utterances with codes you specify (if you ever would want to for some
reason).
}
\examples{
### Get path to example files
examplePath <-
  system.file("extdata", package="rock");

### Get a path to file with example data frame
exampleFile <-
  file.path(examplePath, "spreadsheet-import-test.csv");

### Read data into a data frame
dat <-
  read.csv(exampleFile);

### Convert data frame to a source
source_from_df <-
  convert_df_to_source(
    dat,
    cols_to_utterances = c("open_question_1",
                           "open_question_2"),
    cols_to_ciids = c(cid = "id"),
    cols_to_attributes = c("age", "gender"),
    cols_to_codes = c("code_1", "code_2"),
    ciid_labels = c(cid = "caseId")
 );

### Show the result
cat(
  source_from_df,
  sep = "\n"
);
}
