% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncing_df_expand.R, R/syncing_vector_expand.R
\name{syncing_df_expand}
\alias{syncing_df_expand}
\alias{syncing_vector_expand}
\title{Expand a vector or data frame}
\usage{
syncing_df_expand(
  x,
  newLength,
  fill = TRUE,
  expandFun = NULL,
  silent = rock::opts$get("silent")
)

syncing_vector_expand(
  x,
  newLength,
  fill = TRUE,
  expandFun = NULL,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The vector or data frame}

\item{newLength}{The new length (or number of rows for a data frame)}

\item{fill}{When expanding streams, whether to duplicate elements to fill
the resulting vector. Ignored if \code{fillFun} is specified.}

\item{expandFun}{If specified, when expanding streams, instead of potentially
filling the new larger vector with elements (if \code{fill} is \code{TRUE}), the
vectors are passed to function \code{expandFun}, which must accept a vector (to
compress) and a single integer (with the desired resulting length of
the vector).}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The expanded vector
}
\description{
Expand a vector or data frame
}
\examples{
rock::syncing_vector_expand(letters[1:10], 15);
rock::syncing_vector_expand(letters[1:10], 15, fill=FALSE);
}
