% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_state_transition_df.R
\name{get_state_transition_df}
\alias{get_state_transition_df}
\title{Get the state transition data frame}
\usage{
get_state_transition_df(x)
}
\arguments{
\item{x}{A state transition table as produced by a call
to \code{\link[=get_state_transition_table]{get_state_transition_table()}}.}
}
\value{
A dataframe with columns \code{fromState}, \code{toState},
and \code{nrOfTransitions}.
}
\description{
Get the state transition data frame
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "state-example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Show the state transition probabilities
exampleTable <- rock::get_state_transition_table(
  parsedExample
);

exampleStateDf <- rock::get_state_transition_df(
  exampleTable
);

}
