% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpe_create_source_with_items.R
\name{rpe_create_source_with_items}
\alias{rpe_create_source_with_items}
\title{Create a source with items to code for Response Process Evaluation}
\usage{
rpe_create_source_with_items(
  data,
  iterationId,
  batchId,
  populationId,
  itemVarNames,
  metaquestionIdentifiers,
  metaquestionVarNames,
  itemContents,
  metaquestionContents,
  coderId,
  caseIds = NULL,
  outputFile = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{data}{A (wide) data frame containing at least the participants'
answers to the items and to the meta questions (but optionally, the
iteration, batch, and population).}

\item{iterationId, batchId, populationId}{If the iteration, batch, and
population identifiers are contained in the data frame passed as \code{data},
the variable names holding that information for each participant;
otherwise, either a single value or a vector of length \code{nrow(data)} that
contains that information for each participant.}

\item{itemVarNames}{The variable names with the participants' responses
to the items, in a named character vector, with each element's name being
the item's identifier, and each element the variable name in \code{data} holding
the participants' responses to the item.}

\item{metaquestionIdentifiers}{A named list of unnamed character vectors,
with each character vector element specifying the identifier of a meta
question, and each list element (i.e. the name of each character vector)
specifying the item identifier that the meta questions in the corresponding
character vector belong to.}

\item{metaquestionVarNames}{The variable names with the participants'
responses to the meta questions, in a named character vector, with each
element's name being the meta question's identifier, and each element
the variable name in \code{data} holding the participants' responses to the
meta question.}

\item{itemContents}{A named character vector with each item's content, with
the values being the content and the names the item identifiers.}

\item{metaquestionContents}{A named character vector with each meta
question's content, with the values being the content and the names the
meta question identifiers.}

\item{coderId}{The identifier of the coder that will code this source.}

\item{caseIds}{The variable name with the participants' case identifiers (i.e.
a unique identifier for each participant).}

\item{outputFile}{Optionally, a file to write the source to.}

\item{preventOverwriting}{Whether to overwrite existing files (\code{FALSE}) or
prevent that from happening (\code{TRUE}).}

\item{encoding}{The encoding to use when writing the source(s).}

\item{silent}{Whether to the silent (\code{TRUE}) or chatty (\code{FALSE}).}
}
\value{
The created source, as a character vector (invisibly);
}
\description{
This function creates a plain text file, a \code{.rock} source, that can be
coded when conducting Response Process Evaluation.
}
