% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_functions.R
\name{extract_roc_text}
\alias{extract_roc_text}
\title{Extract a section, parameter or set of dot-parameters from a function documentation}
\usage{
extract_roc_text(
  fun,
  type = c("general", "section", "param", "dot_params"),
  select = NULL,
  capitalize = TRUE
)
}
\arguments{
\item{fun}{Function or character indicating function name.}

\item{type}{Type of extraction. If content is extracted by \code{@inherit} tags,
set to \code{"general"}; if by \code{@inheritSection}, set to \code{section};
if by \code{@inheritParams}, set to \code{param}; if by \code{@inheritDotParams},
set to \code{"dot_params"}.}

\item{select}{Selection of extraction.
For \code{type = "general"}, character indicating the section to extract.
For \code{type = "section"}, character indicating the section title to extract.
For \code{type = "param"}, character indicating the name of parameter to extract.
For \code{type = "dot_params"}, character or character vector to add or remove (with "-") parameters as \code{@inheritDotParams};
if character vector provided, the elements are concatenated with spaces just as \code{@inheritDotParams} syntax.
to inherit, e.g. \code{"x,y"} to inherit 2 parameters or \code{"-z"} to remove a parameter.}

\item{capitalize}{Logical indicating whether the first letter of the return should be capitalized.
If \code{capitalize = NA}, the return is left as is.}
}
\value{
Character as valid Rd text to diffuse into \code{\link[roxygen2]{roxygen2}} comments.
}
\description{
\code{extract_roc_text} cites sections or parameters from a function documentation
in the syntax of \code{@inherit}, \code{@inheritSection}, \code{@inheritParams} or \code{@inheritDotParams} tag
from \code{\link[roxygen2]{roxygen2}} package. See details about how to use this function.
}
\details{
To diffuse the function output into \code{\link[roxygen2]{roxygen2}} comments,
one may write the function documentation like this:
\preformatted{
#' Function documentation for the diffusion of parameter descriptions
#'
#' @param lm_list Named list of
#' `r extract_roc_text(stats::lm, type = "dot_params", select = c("-formula", "-data"), capitalize = FALSE)`
#'
my_fun <- function(lm_list) {}
}
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Inherit a standard section, and leave the first letter as is
cat(
  extract_roc_text(stats::lm,
                   type = "general",
                   select = "description",
                   capitalize = NA)
)

# Inherit a self-defined section, and capitalize the first letter
cat(
  extract_roc_text(stats::lm,
                   type = "section",
                   select = "Using time series",
                   capitalize = TRUE)
)

# Inherit a parameter, and diffuse it into text
cat(
  paste0(
    "Here is the `formula` argument of `stats::lm`, defined as: ",
    extract_roc_text(stats::lm,
                     type = "param",
                     select = "formula",
                     capitalize = FALSE)
  )
)

# Inherit a set of dot params, and diffuse it into text
cat(
  paste0(
    "`lm_arg` is a named list of ",
    extract_roc_text(stats::lm,
                     type = "dot_params",
                     select = c("-formula", "-data"),
                     capitalize = FALSE)
  )
)
}
\author{
Xiurui Zhu
}
