% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{get_dimension_attribute_names}
\alias{get_dimension_attribute_names}
\alias{get_dimension_attribute_names.star_database}
\title{Get the names of the attributes of a dimension}
\usage{
get_dimension_attribute_names(db, name)

\method{get_dimension_attribute_names}{star_database}(db, name)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{name}{A string, dimension name.}
}
\value{
A vector of strings, attribute names.
}
\description{
Obtain the names of the attributes of a dimension.
}
\examples{

names <- star_database(mrs_cause_schema, ft_num) |>
  get_dimension_attribute_names(name = "where")

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{get_fact_measure_names}()},
\code{\link{get_role_playing_dimension_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{set_dimension_attribute_names}()},
\code{\link{set_fact_measure_names}()},
\code{\link{snake_case}()},
\code{\link{star_database}()}
}
\concept{star database and constellation definition functions}
