% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_join.R
\name{get_pk_attribute_names}
\alias{get_pk_attribute_names}
\alias{get_pk_attribute_names.flat_table}
\title{Get the names of the primary key attributes of a flat table}
\usage{
get_pk_attribute_names(ft, as_definition)

\method{get_pk_attribute_names}{flat_table}(ft, as_definition = FALSE)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{as_definition}{A boolean, as the definition of the vector in R.}
}
\value{
A vector of strings or a \code{tibble}, attribute names.
}
\description{
Obtain the names of the attributes that form the primary key of a flat table,
if defined.
}
\examples{

ft <- flat_table('iris', iris) |>
  lookup_table(
    measures = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
    measure_agg = c('MAX', 'MIN', 'SUM', 'MEAN')
  )
names <- ft |>
  get_pk_attribute_names()

}
\seealso{
\code{\link{flat_table}}

Other flat table join functions: 
\code{\link{check_lookup_table}()},
\code{\link{join_lookup_table}()},
\code{\link{lookup_table}()}
}
\concept{flat table join functions}
